--
-- Rufa Multiplayer Event Script
--
-- M@D Author:  Heady
-- M@D date: 04.08.2011
--
-- > Copyright (C) Heady - www.planet-ls.de < --
--

RufaMPEvent = {};
RufaMPEvent_mt = Class(RufaMPEvent, Event);

InitEventClass(RufaMPEvent, "RufaMPEvent");

function RufaMPEvent:emptyNew()
    local self = Event:new(RufaMPEvent_mt);
    self.className="RufaMPEvent";
    return self;
end;

function RufaMPEvent:new(object)
    local self = RufaMPEvent:emptyNew()
    self.object = object;
    return self;
end;

function RufaMPEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));	

	self.object.accDirection = streamReadFloat32(streamId);	
	self.object.rufa.active = streamReadBool(streamId);

	if not connection:getIsServer() then
		g_server:broadcastEvent(RufaMPEvent:new(self.object), nil, connection, self.object);
	end;

end;

function RufaMPEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));	
	
	streamWriteFloat32(streamId, self.object.accDirection);	
	streamWriteBool(streamId, self.object.rufa.active);
end;

function RufaMPEvent:updateSendEvent(runSelf)	

	if g_server ~= nil then
		g_server:broadcastEvent(RufaMPEvent:new(runSelf));
	else
		g_client:getServerConnection():sendEvent(RufaMPEvent:new(runSelf));
	end;

end;