--
-- moveAbleBottomArm
-- Specialization class for moveAbleBottomArm
--
-- @author  Geri-G
-- @date  01/01/2011


moveAbleBottomArm = {};


function moveAbleBottomArm.prerequisitesPresent(specializations)
    return true;
end;

function moveAbleBottomArm:load(xmlFile)
	self.bottomArmJointIndex = Utils.getNoNil(getXMLInt(xmlFile,"vehicle.frontArm#jointIndicies"),0)+1;
	self.bottomArmNode = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.frontArm#node"));
	self.bottomArmMaxRot = Utils.getRadiansFromString(getXMLString(xmlFile,"vehicle.frontArm#maxRot"),3);
	self.bottomArmMinRot = Utils.getRadiansFromString(getXMLString(xmlFile,"vehicle.frontArm#minRot"),3);
	setRotation(self.bottomArmNode,unpack(self.bottomArmMaxRot));
end;

function moveAbleBottomArm:delete()

end;

function moveAbleBottomArm:readStream(streamId, connection)

end;

function moveAbleBottomArm:writeStream(streamId, connection)

end;

function moveAbleBottomArm:readUpdateStream(streamId, timestamp, connection)

end;

function moveAbleBottomArm:writeUpdateStream(streamId, connection, dirtyMask)

end;

function moveAbleBottomArm:mouseEvent(posX, posY, isDown, isUp, button)

end;

function moveAbleBottomArm:keyEvent(unicode, sym, modifier, isDown)
end;

function moveAbleBottomArm:update(dt)
 

end;

function moveAbleBottomArm:updateTick(dt)

end;


function moveAbleBottomArm:draw()
end;

function moveAbleBottomArm:attachImplement(implement)
	if self.bottomArmJointIndex == implement.jointDescIndex then
		setRotation(self.bottomArmNode,unpack(self.bottomArmMinRot));
	end;
end;

function moveAbleBottomArm:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	if self.bottomArmJointIndex == implement.jointDescIndex then
		setRotation(self.bottomArmNode,unpack(self.bottomArmMaxRot));
	end;
end;

