BuyableWheelWeightsAttachEvent = {};
BuyableWheelWeightsAttachEvent_mt = Class(BuyableWheelWeightsAttachEvent, Event);

InitEventClass(BuyableWheelWeightsAttachEvent, "BuyableWheelWeightsAttachEvent");

function BuyableWheelWeightsAttachEvent:emptyNew()
    local self = Event:new(BuyableWheelWeightsAttachEvent_mt);
    self.className="BuyableWheelWeightsAttachEvent";
    return self;
end;

function BuyableWheelWeightsAttachEvent:new(vehicle, attacherVehicle)
    local self = BuyableWheelWeightsAttachEvent:emptyNew()
    self.vehicle = vehicle;
	self.attacherVehicle = attacherVehicle;
    return self;
end;

function BuyableWheelWeightsAttachEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	local attacherId = streamReadInt32(streamId);
	self.attacherVehicle = networkGetObject(attacherId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function BuyableWheelWeightsAttachEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt32(streamId, networkGetObjectId(self.attacherVehicle));
end;

function BuyableWheelWeightsAttachEvent:run(connection)
	self.vehicle:assembleWeights(self.attacherVehicle, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(BuyableWheelWeightsAttachEvent:new(self.vehicle, self.attacherVehicle), nil, connection, self.object);
    end;
end;


function BuyableWheelWeightsAttachEvent.sendEvent(vehicle, attacherVehicle, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(BuyableWheelWeightsAttachEvent:new(vehicle, attacherVehicle), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(BuyableWheelWeightsAttachEvent:new(vehicle, attacherVehicle));
		end;
	end;
end;