--
-- BuyableWheelWeightsAttacher
-- Specialization for BuyableWheelWeightsAttacher
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  23/04/10
-- Edit By Ufolec

BuyableWheelWeightsAttacher = {};

function BuyableWheelWeightsAttacher.prerequisitesPresent(specializations)
    return true;
end;

function BuyableWheelWeightsAttacher:load(xmlFile)

	self.onAssemblingWeights = SpecializationUtil.callSpecializationsFunction("onAssemblingWeights");
	self.onDisassemblingWeights = SpecializationUtil.callSpecializationsFunction("onDisassemblingWeights");
	
	self.buyableWheelWeights = {};
	self.buyableWheelWeights.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheels#wheelWeightsCheckString"), "standart");
	self.buyableWheelWeights.wheelWeights = nil;
	self.buyableWheelWeights.wheelsInRange = nil;	
end;

function BuyableWheelWeightsAttacher:delete()
	if self.buyableWheelWeights.wheelWeights ~= nil then
		self.buyableWheelWeights.wheelWeights:disassembleWeights(true);
	end;
end;

function BuyableWheelWeightsAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BuyableWheelWeightsAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function BuyableWheelWeightsAttacher:update(dt)

	if self:getIsActive() then
		local wheels = self.buyableWheelWeights;
		if wheels.wheelsInRange ~= nil then
			if self:getIsActiveForInput(false) then
				if InputBinding.hasEvent(InputBinding.BUYABLE_WHEELWEIGHTS_ATTACH) then
					if wheels.wheelWeights == nil then
						wheels.wheelsInRange:assembleWeights(self);
					else
						if wheels.wheelsInRange.wheelWeightsUser == self then
							wheels.wheelsInRange:disassembleWeights();
						end;
					end;
				end;
			end;
		end;
	end;
end;

function BuyableWheelWeightsAttacher:draw()
	local wheels = self.buyableWheelWeights;
	if wheels.wheelsInRange ~= nil then
		if wheels.wheelWeights ~= nil then
			if wheels.wheelsInRange.wheelWeightsUser == self then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableWheelWeights_disassemble"), InputBinding.BUYABLE_WHEELWEIGHTS_ATTACH);
			end;
		else
			if wheels.wheelsInRange.wheelWeightsUser == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableWheelWeights_assemble"), InputBinding.BUYABLE_WHEELWEIGHTS_ATTACH);
			end;
		end;
	end;
end;

function BuyableWheelWeightsAttacher:onAssemblingWeights(buyableWheelWeights)
	self.buyableWheelWeights.wheelWeights = buyableWheelWeights;
end;

function BuyableWheelWeightsAttacher:onDisassemblingWeights()
	self.buyableWheelWeights.wheelWeights = nil;
end;
