BuyableWheelWeightsDetachEvent = {};
BuyableWheelWeightsDetachEvent_mt = Class(BuyableWheelWeightsDetachEvent, Event);

InitEventClass(BuyableWheelWeightsDetachEvent, "BuyableWheelWeightsDetachEvent");

function BuyableWheelWeightsDetachEvent:emptyNew()
    local self = Event:new(BuyableWheelWeightsDetachEvent_mt);
    self.className="BuyableWheelWeightsDetachEvent";
    return self;
end;

function BuyableWheelWeightsDetachEvent:new(vehicle)
    local self = BuyableWheelWeightsDetachEvent:emptyNew()
    self.vehicle = vehicle;
    return self;
end;

function BuyableWheelWeightsDetachEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function BuyableWheelWeightsDetachEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
end;

function BuyableWheelWeightsDetachEvent:run(connection)
	self.vehicle:disassembleWeights(true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(BuyableWheelWeightsDetachEvent:new(self.vehicle), nil, connection, self.object);
    end;
end;


function BuyableWheelWeightsDetachEvent.sendEvent(vehicle, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(BuyableWheelWeightsDetachEvent:new(vehicle), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(BuyableWheelWeightsDetachEvent:new(vehicle));
		end;
	end;
end;