	  --------------------------
	  -- Scrypt do URSUS 1204 --
	  --    By maciusboss1    --
	  --      15.11.2013      --
	  --    Pomoc:   Burner   --
	  --    !!! NO EDIT !!!   --
	  --------------------------
	  
	  
Ursus1204 = {};

function Ursus1204.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Ursus1204:load(xmlFile)
	self.isSelectable = true 
	self.objectInRange = Ursus1204.objectInRange;
	self.walNapedowy4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.walNapedowy4#index"));
	self.walNapedowy1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.walNapedowy1#index"));
	self.walNapedowy2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.walNapedowy2#index"));
	self.walNapedowy3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.walNapedowy3#index"));
	self.walNapedowy5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.walNapedowy5#index"));
	self.walNapedowy6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.walNapedowy6#index"));


   
	self.roll1Nodes = {};

    local roll1Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.roll1#index"));
    if roll1Node ~= nil then
        local speed = 0.003*3;
        table.insert(self.roll1Nodes, {node=roll1Node, speed=speed});
    end;
    local i = 0;
    while true do
        local key = string.format("vehicle.rolls1.roll1(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local roll1Node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"), 0.003);
        if roll1Node ~= nil then
            table.insert(self.roll1Nodes, {node=roll1Node, speed=speed});
        end;
        i = i + 1;
    end;
	
	self.isSelectable = true;
end;

function Ursus1204:keyEvent(unicode, sym, modifier, isDown)
end;

function Ursus1204:update(dt)

	rotate(self.walNapedowy4, 0,0,2.5 * self.lastSpeedReal * self.movingDirection * dt);
    rotate(self.walNapedowy1, 0,0,2.5 * self.lastSpeedReal * self.movingDirection * dt);
    rotate(self.walNapedowy2, 0,0,2.5 * self.lastSpeedReal * self.movingDirection * dt);
    rotate(self.walNapedowy3, 0,0,2.5 * self.lastSpeedReal * self.movingDirection * dt);
    rotate(self.walNapedowy5, 0,0,2.5 * self.lastSpeedReal * self.movingDirection * dt);
    rotate(self.walNapedowy6, 0,0,2.5 * self.lastSpeedReal * self.movingDirection * dt);
    
    if self.isMotorStarted then
		for _, roll1Node in pairs(self.roll1Nodes) do
			rotate(roll1Node.node, -dt*roll1Node.speed, 0, 0);
		end;
	end;

	if self:objectInRange(self.animationParts[1].rootNode) or self:getIsActiveForInput(false) then
		if InputBinding.hasEvent(InputBinding.Ursus1204_DRZWIP) then
			if self.animationParts[1].clipEndTime then
				self:setAnimationTime(1, self.animationParts[1].offSet);
			elseif self.animationParts[1].clipStartTime then
				self:setAnimationTime(1, self.animationParts[1].animDuration);
			end;
		end;
	end;
	
	if self:objectInRange(self.animationParts[1].rootNode) then
		if self.animationParts[1].clipEndTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Ursus1204_DRZWIPZamknij")), InputBinding.Ursus1204_DRZWIP);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Ursus1204_DRZWIP")), InputBinding.Ursus1204_DRZWIP);
		end;
	end;
	
	if self:objectInRange(self.animationParts[2].rootNode) or self:getIsActiveForInput(false) then
		if InputBinding.hasEvent(InputBinding.Ursus1204_DRZWIL) then
			if self.animationParts[2].clipEndTime then
				self:setAnimationTime(2, self.animationParts[2].offSet);
			elseif self.animationParts[2].clipStartTime then
				self:setAnimationTime(2, self.animationParts[2].animDuration);
			end;                                                                                                                     
		end;
	end;
	
	if self:objectInRange(self.animationParts[2].rootNode) then
		if self.animationParts[2].clipEndTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Ursus1204_DRZWILZamknij")), InputBinding.Ursus1204_DRZWIL);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Ursus1204_DRZWIL")), InputBinding.Ursus1204_DRZWIL);
		end;
	end;
		
	if self:getIsActiveForInput(false) then
		if self.isClient then
			if InputBinding.hasEvent(InputBinding.Ursus1204_DACH) then
				if self.animationParts[3].clipEndTime then
					self:setAnimationTime(3, self.animationParts[3].offSet);
				elseif self.animationParts[3].clipStartTime then
					self:setAnimationTime(3, self.animationParts[3].animDuration);
				end;
			end;
			if self:objectInRange(self.animationParts[3].rootNode) then
				if self.animationParts[3].clipEndTime then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Ursus1204_DACHZamknij")), InputBinding.Ursus1204_DACH);
				else
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Ursus1204_DACH")), InputBinding.Ursus1204_DACH);
				end;
			end;
		
			if InputBinding.hasEvent(InputBinding.Ursus1204_SZYBAT) then
				if self.animationParts[4].clipEndTime then
					self:setAnimationTime(4, self.animationParts[4].offSet);
				elseif self.animationParts[4].clipStartTime then
					self:setAnimationTime(4, self.animationParts[4].animDuration);
				end;
			end;
			if self:objectInRange(self.animationParts[4].rootNode) then
				if self.animationParts[4].clipEndTime then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Ursus1204_SZYBATZamknij")), InputBinding.Ursus1204_SZYBAT);
				else
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Ursus1204_SZYBAT")), InputBinding.Ursus1204_SZYBAT);
				end;
			end;
			
			if InputBinding.isPressed(InputBinding.Ursus1204_ZACZEPDOWN) then
				self:setAnimationTime(5, self.animationParts[5].currentPosition+(self.animationParts[5].offSet+dt), false);
			elseif InputBinding.isPressed(InputBinding.Ursus1204_ZACZEPUP) then
				self:setAnimationTime(5, self.animationParts[5].currentPosition-(self.animationParts[5].offSet+dt), false);
			end;
		end;
    end;
end;

function Ursus1204:draw()
	g_currentMission:addExtraPrintText(string.format(""..InputBinding.getKeyNamesOfDigitalAction(InputBinding.Ursus1204_ZACZEPDOWN) .. " / " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.Ursus1204_ZACZEPUP)..": "..g_i18n:getText("Ursus1204_ZACZEPUP")..""));
end;

function Ursus1204:onEnter()
end;

function Ursus1204:onLeave()
end;

function Ursus1204:delete()
end;

function Ursus1204:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Ursus1204:validateAttacherJoint(implement, jointDesc, dt)
	return true;
end;

function Ursus1204:objectInRange(object)
	if g_currentMission.player ~= nil and object ~= nil then
		local nearestDistance = 3;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local px, py, pz = getWorldTranslation(object);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			return true;
		else
			return false;
		end;
	else
		return false;
	end;
end;