--
-- BuyableDualRearAttacher
-- Specialization for BuyableDualRearAttacher
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  23/04/10
-- @history:	v1.0 and v2.0 by SFM
--				

BuyableDualRearAttacher = {};

function BuyableDualRearAttacher.prerequisitesPresent(specializations)
    return true;
end;

function BuyableDualRearAttacher:load(xmlFile)

	self.onAssembling = SpecializationUtil.callSpecializationsFunction("onAssembling");
	self.onDisassembling = SpecializationUtil.callSpecializationsFunction("onDisassembling");
	
	self.BuyableDualRear = {};
	self.BuyableDualRear.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheels#twinWheelsCheckString"), "standart");
	self.BuyableDualRear.twinWheels = nil;
	self.BuyableDualRear.wheelsInRange = nil;	
end;

function BuyableDualRearAttacher:delete()
	if self.BuyableDualRear.twinWheels ~= nil then
		self.BuyableDualRear.twinWheels:disassembleWheels(true);
	end;
end;

function BuyableDualRearAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BuyableDualRearAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function BuyableDualRearAttacher:update(dt)

	if self:getIsActive() then
		local wheels = self.BuyableDualRear;
		if wheels.wheelsInRange ~= nil then
			if self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.JDBuyableDualRear) then
					if wheels.twinWheels == nil then
						wheels.wheelsInRange:assembleWheels(self);
					else
						if wheels.wheelsInRange.twinWheelsUser == self then
							wheels.wheelsInRange:disassembleWheels();
						end;
					end;
				end;
			end;
		end;
	end;
end;

function BuyableDualRearAttacher:draw()
	local wheels = self.BuyableDualRear;
	if wheels.wheelsInRange ~= nil then
		if wheels.twinWheels ~= nil then
			if wheels.wheelsInRange.twinWheelsUser == self then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_disassemble"), InputBinding.JDBuyableDualRear);
			end;
		else
			if wheels.wheelsInRange.twinWheelsUser == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_assemble"), InputBinding.JDBuyableDualRear);
			end;
		end;
	end;
end;

function BuyableDualRearAttacher:onAssembling(BuyableDualRear)
	self.BuyableDualRear.twinWheels = BuyableDualRear;
	if self.setFenderVisibility ~= nil then
		self:setFenderVisibility(true);
	end;
end;

function BuyableDualRearAttacher:onDisassembling()
	self.BuyableDualRear.twinWheels = nil;
   if self.setFenderVisibility ~= nil then
		self:setFenderVisibility(false);
	end;
end;
