Bizon_Z083_cutter = {};

function Bizon_Z083_cutter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function Bizon_Z083_cutter:load(xmlFile)
	self.mountCropDividers = SpecializationUtil.callSpecializationsFunction("mountCropDividers");
	self.mountRapeTable = SpecializationUtil.callSpecializationsFunction("mountRapeTable");
	self.objectInRange = Bizon_Z083_cutter.objectInRange;
	
	self.threshingParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.threshingParticleSystems.threshingParticleSystem(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end;
		local isStatic = Utils.getNoNil(getXMLBool(xmlFile, namei.."#static"), false);
		if isStatic then
			StaticParticleSystem.loadParticleSystem(xmlFile, self.threshingParticleSystems, namei, nodei, false, nil, self.baseDirectory);
		else
			Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems, namei, nodei, false, nil, self.baseDirectory);
		end;
		Utils.setEmittingState(self.threshingParticleSystems,false);
		i = i +1;		
    end;
	
	local cutterSound = getXMLString(xmlFile, "vehicle.cutterSound#file");
	if cutterSound ~= nil and cutterSound ~= "" then
		cutterSound = Utils.getFilename(cutterSound, self.baseDirectory);
		self.cutterSound = createSample("cutterSound");
		self.cutterSoundEnabled = false;
		loadSample(self.cutterSound, cutterSound, false);
		self.cutterSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cutterSound#pitchOffset"), 1);
		self.cutterSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cutterSound#volume"), 1);
	end;
	
	self.cropDividers = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cropDividers#index"));
	if self.cropDividers ~= nil then
		setVisibility(self.cropDividers, false);
	end;
	self.cropDividersActive = false;
	
	self.rapeTable = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rapeTable#index"));
	if self.rapeTable ~= nil then
		setVisibility(self.rapeTable, false);
	end;
	self.rapeTableActive = false;
	
	self.displayRapeTableInfo = false;
	self.allowAttachHydraulicHose = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.allowAttachHydraulicHose"), false);
	
	self.reelUp = false;
	self.reelDown = false;
	self.reelForward = false;
	self.reelBackward = false;
end;

function Bizon_Z083_cutter:delete()
	if self.cutterSound ~= nil then
		delete(self.cutterSound);
		self.cutterSoundEnabled = false;
	end;
end;

function Bizon_Z083_cutter:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'cropDividers="'.. tostring(self.cropDividersActive) ..'" rapeTable="'.. tostring(self.rapeTableActive) ..'"';
	return attributes, nil;
end;

function Bizon_Z083_cutter:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local cropDividersActive = Utils.getNoNil(getXMLBool(xmlFile, key.."#cropDividers"), false);
		local rapeTableActive = Utils.getNoNil(getXMLBool(xmlFile, key.."#rapeTable"), false);
		self:mountCropDividers(cropDividersActive);
		self:mountRapeTable(rapeTableActive);
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function Bizon_Z083_cutter:readStream(streamId, connection)
	self:mountCropDividers(streamReadBool(streamId), true);
	self:mountRapeTable(streamReadBool(streamId), true);
end;

function Bizon_Z083_cutter:writeStream(streamId, connection)
	streamWriteBool(streamId, self.cropDividersActive);
	streamWriteBool(streamId, self.rapeTableActive);
end;

function Bizon_Z083_cutter:readUpdateStream(streamId, timestamp, connection)
end;

function Bizon_Z083_cutter:writeUpdateStream(streamId, connection, dirtyMask)
end;

function Bizon_Z083_cutter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Bizon_Z083_cutter:keyEvent(unicode, sym, modifier, isDown)
end;

function Bizon_Z083_cutter:update(dt)
	self.reelUp = false;
	self.reelDown = false;
	self.reelForward = false;
	self.reelBackward = false;
	
	if self.isClient then
		if self:objectInRange(self.cropDividers) then
			if self.rapeTableActive == false then
				if InputBinding.hasEvent(InputBinding.BizonGigantCutter_MountCropDividers) then
					self:mountCropDividers(not self.cropDividersActive);
				end;
				if self.cropDividersActive then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BizonGigantCutter_CropDividersUnmount")), InputBinding.BizonGigantCutter_MountCropDividers);
				else
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BizonGigantCutter_CropDividersMount")), InputBinding.BizonGigantCutter_MountCropDividers);
				end;
			else
				g_currentMission:addExtraPrintText(g_i18n:getText("BizonGigantCutter_UnmountRapeTableInfo"));
			end;
		end;
		if self:objectInRange(self.rapeTable) then
			if self.cropDividersActive == false then
				if InputBinding.hasEvent(InputBinding.BizonGigantCutter_MountRapeTable) then
					self:mountRapeTable(not self.rapeTableActive);
				end;
				if self.rapeTableActive then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BizonGigantCutter_RapeTableUnmount")), InputBinding.BizonGigantCutter_MountRapeTable);
				else
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BizonGigantCutter_RapeTableMount")), InputBinding.BizonGigantCutter_MountRapeTable);
				end;
			else
				g_currentMission:addExtraPrintText(g_i18n:getText("BizonGigantCutter_UnmountCropDividersInfo"));
			end;
		end;
	end;
	
    if self:getIsActiveForInput() then
		if InputBinding.isPressed(InputBinding.BizonGigantCutter_ReelUp) then
			if self.animationParts[1].clipEndTime == false then
				self.reelUp = true;
				self:setAnimationTime(1, self.animationParts[1].currentPosition+(self.animationParts[1].offSet+dt), false);
			end;
		elseif InputBinding.isPressed(InputBinding.BizonGigantCutter_ReelDown) then
			if self.animationParts[1].clipStartTime == false then
				self.reelDown = true;
				self:setAnimationTime(1, self.animationParts[1].currentPosition-(self.animationParts[1].offSet+dt), false);
			end;
		end;
		if InputBinding.isPressed(InputBinding.BizonGigantCutter_ReelBack) then
			if self.animationParts[2].clipStartTime == false then
				self.reelBackward = true;
				self:setAnimationTime(2, self.animationParts[2].currentPosition-(self.animationParts[2].offSet+dt), false);
			end;
		elseif InputBinding.isPressed(InputBinding.BizonGigantCutter_ReelFront) then
			if self.animationParts[2].clipEndTime == false then
				self.reelForward = true;
				self:setAnimationTime(2, self.animationParts[2].currentPosition+(self.animationParts[2].offSet+dt), false);
			end;
		end;
    end;
	if self.reelStarted then
		self:setAnimationTime(3, 1);
		if self.isClient and self:getIsActiveForSound() then
			if not self.cutterSoundEnabled and self:getIsActiveForSound() then
				setSamplePitch(self.cutterSound, self.cutterSoundPitchOffset);
				playSample(self.cutterSound, 0, self.cutterSoundVolume, 0);
				self.cutterSoundEnabled = true;
			end;
		end;
	else
		self:setAnimationTime(3, 0);
		if self.isClient and self:getIsActiveForSound() then
			if self.cutterSoundEnabled then
				stopSample(self.cutterSound);
				self.cutterSoundEnabled = false;
			end;
		end;
	end;
	if self.attacherVehicle ~= nil then
		if self.currentFruitType == FruitUtil.FRUITTYPE_RAPE and self.rapeTableActive == false then
			self.attacherVehicle.threshingScale = 0.8;
			self.displayRapeTableInfo = true;
		else
			self.attacherVehicle.threshingScale = 1;
			self.displayRapeTableInfo = false;
		end;
	end;
end;

function Bizon_Z083_cutter:updateTick(dt)
end;

function Bizon_Z083_cutter:draw()
	if self.isClient then
		if self.displayRapeTableInfo then
			g_currentMission:addExtraPrintText(g_i18n:getText("BizonGigantCutter_RapeTableInfo"));
		end;
		if self.attacherVehicle ~= nil and self.attacherVehicle.helpPanelActive then
			setTextBold(false);
			if self.reelUp then
				setTextColor(0,1,0,1);
				renderText(0.72, 0.66, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigantCutter_ReelUp), "PAD", "")..": "..g_i18n:getText("BizonGigantCutter_ReelUp"))));
			else
				setTextColor(1,1,1,1);
				renderText(0.72, 0.66, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigantCutter_ReelUp), "PAD", "")..": "..g_i18n:getText("BizonGigantCutter_ReelUp"))));
			end;
			if self.reelDown then
				setTextColor(0,1,0,1);
				renderText(0.72, 0.64, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigantCutter_ReelDown), "PAD", "")..": "..g_i18n:getText("BizonGigantCutter_ReelDown"))));
			else
				setTextColor(1,1,1,1);
				renderText(0.72, 0.64, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigantCutter_ReelDown), "PAD", "")..": "..g_i18n:getText("BizonGigantCutter_ReelDown"))));
			end;
			if self.reelForward then
				setTextColor(0,1,0,1);
				renderText(0.72, 0.62, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigantCutter_ReelFront), "PAD", "")..": "..g_i18n:getText("BizonGigantCutter_ReelFront"))));
			else
				setTextColor(1,1,1,1);
				renderText(0.72, 0.62, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigantCutter_ReelFront), "PAD", "")..": "..g_i18n:getText("BizonGigantCutter_ReelFront"))));
			end;
			if self.reelBackward then
				setTextColor(0,1,0,1);
				renderText(0.72, 0.60, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigantCutter_ReelBack), "PAD", "")..": "..g_i18n:getText("BizonGigantCutter_ReelBack"))));
			else
				setTextColor(1,1,1,1);
				renderText(0.72, 0.60, 0.018, (string.format(string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.BizonGigantCutter_ReelBack), "PAD", "")..": "..g_i18n:getText("BizonGigantCutter_ReelBack"))));
			end;
		end;
		setTextColor(1,1,1,1);
	end;
end;

function Bizon_Z083_cutter:onAttach(attacherVehicle)
	self.av = attacherVehicle;
end;

function Bizon_Z083_cutter:onDetach()
	self.av.threshingScale = 1;
end;

function Bizon_Z083_cutter:onLeave()
end;

function Bizon_Z083_cutter:onDeactivate()
	Bizon_Z083_cutter.onDeactivateSounds(self)
end;

function Bizon_Z083_cutter:onDeactivateSounds()
	if self.cutterSoundEnabled then
		stopSample(self.cutterSound);
		self.cutterSoundEnabled = false;
	end;
end;

function Bizon_Z083_cutter:objectInRange(object)
	if g_currentMission.player ~= nil and object ~= nil then
		local nearestDistance = 2;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local px, py, pz = getWorldTranslation(object); 
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			return true;
		else
			return false;
		end;
	else
		return false;
	end;
end;

function Bizon_Z083_cutter:mountCropDividers(cropDividersActive, noEventSend)
	MountCropDividersEvent.sendEvent(self, cropDividersActive, noEventSend);
	self.cropDividersActive = cropDividersActive;
	if self.cropDividers ~= nil then
		setVisibility(self.cropDividers, cropDividersActive);
	end;
end;

function Bizon_Z083_cutter:mountRapeTable(rapeTableActive, noEventSend)
	MountRapeTableEvent.sendEvent(self, rapeTableActive, noEventSend);
	self.rapeTableActive = rapeTableActive;
	if self.rapeTable ~= nil then
		setVisibility(self.rapeTable, rapeTableActive);
	end;
end;