MountCropDividersEvent = {};
MountCropDividersEvent_mt = Class(MountCropDividersEvent, Event);

InitEventClass(MountCropDividersEvent, "MountCropDividersEvent");

function MountCropDividersEvent:emptyNew()
    local self = Event:new(MountCropDividersEvent_mt);
    self.className="MountCropDividersEvent";
    return self;
end;

function MountCropDividersEvent:new(vehicle, cropDividersState)
    local self = MountCropDividersEvent:emptyNew()
    self.vehicle = vehicle;
	self.cropDividersState = cropDividersState;
    return self;
end;

function MountCropDividersEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.cropDividersState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function MountCropDividersEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.cropDividersState);
end;

function MountCropDividersEvent:run(connection)   
	self.vehicle:mountCropDividers(self.cropDividersState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(MountCropDividersEvent:new(self.vehicle, self.cropDividersState), nil, connection, self.vehicle);
    end;
end;

function MountCropDividersEvent.sendEvent(vehicle, cropDividersState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MountCropDividersEvent:new(vehicle, cropDividersState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(MountCropDividersEvent:new(vehicle, cropDividersState));
		end;
	end;
end;

MountRapeTableEvent = {};
MountRapeTableEvent_mt = Class(MountRapeTableEvent, Event);

InitEventClass(MountRapeTableEvent, "MountRapeTableEvent");

function MountRapeTableEvent:emptyNew()
    local self = Event:new(MountRapeTableEvent_mt);
    self.className="MountRapeTableEvent";
    return self;
end;

function MountRapeTableEvent:new(vehicle, rapeTableState)
    local self = MountRapeTableEvent:emptyNew()
    self.vehicle = vehicle;
	self.rapeTableState = rapeTableState;
    return self;
end;

function MountRapeTableEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.rapeTableState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function MountRapeTableEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.rapeTableState);
end;

function MountRapeTableEvent:run(connection)   
	self.vehicle:mountRapeTable(self.rapeTableState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(MountRapeTableEvent:new(self.vehicle, self.rapeTableState), nil, connection, self.vehicle);
    end;
end;

function MountRapeTableEvent.sendEvent(vehicle, rapeTableState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MountRapeTableEvent:new(vehicle, rapeTableState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(MountRapeTableEvent:new(vehicle, rapeTableState));
		end;
	end;
end;