aufnahme = {};

function aufnahme.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function aufnahme:load(xmlFile)
  

    local attachNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.attach#index"));
    if attachNode ~= nil then
        self.attach = {};
        self.attach.node = attachNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.attach#minRot"));
        self.attach.minRot = {};
        self.attach.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.attach.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.attach.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.attach#maxRot"));
        self.attach.maxRot = {};
        self.attach.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.attach.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.attach.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.attach.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.attach#rotTime"), 2)*1000;
        self.attach.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.attach#touchRotLimit"), 10));
    end;
	self.worklightsActive = false;
   
		local hydraulikSample = getXMLString(xmlFile, "vehicle.hydraulikSample#file");
		if hydraulikSample ~= nil and hydraulikSample ~= "" then
        hydraulikSample = Utils.getFilename(hydraulikSample, self.baseDirectory); 
        self.hydraulikSample = createSample("hydraulikSample");
        loadSample(self.hydraulikSample, hydraulikSample, false);
        self.hydraulikSamplePitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hydraulikSample#pitchOffset"), 1);
        self.hydraulikSampleVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hydraulikSample#volume"), 1);
		end;
		sampleisplaying = false
end;

function aufnahme:delete()
    delete(self.hydraulikSample);
end;

function aufnahme:getSaveAttributesAndNodes(nodeIdent)
   
end;

 
function aufnahme:mouseEvent(posX, posY, isDown, isUp, button)
end;
 
function aufnahme:keyEvent(unicode, sym, modifier, isDown)

	if sym == Input.KEY_r then
		self.attachMax = isDown;
	end;
	if sym == Input.KEY_t then
		self.attachMin = isDown;
	end;
end;

function aufnahme:update(dt)
	if self:getIsActiveForInput() then
      
			local doRotate = self.attachMax or self.attachMin 
			if self.attach ~= nil and doRotate then
				local x, y, z = getRotation(self.attach.node);		
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.attach.maxRot, self.attach.minRot, 3, self.attach.rotTime, dt, not self.attachMax);
				setRotation(self.attach.node, unpack(newRot));
				sampleisplaying = true
			else
				sampleisplaying = false
			end;
	end;
	
	if sampleisplaying == true then
		playSample(self.hydraulikSample, 1, self.hydraulikSample, 0);
	else
		stopSample(self.hydraulikSample);
	end;	
	
end;
	
function aufnahme:onLeave()

end;

function aufnahme:draw()
if self:getIsActiveForInput() then
	g_currentMission:addExtraPrintText(g_i18n:getText("AUFNAHME"))
end;	
end;

function aufnahme:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

function aufnahme:openPipe() 
end;