-- by modelleicher
-- www.schwabenmodding.bplaced.net
-- BETA Script!
-- LS 13 Fixed Version: camera works also if tractor is not selected

realisticIndoorCamBeta2 = {};

function realisticIndoorCamBeta2.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function realisticIndoorCamBeta2:load(xmlFile)	
	self.ric = {};
	self.ric.directionPart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.realisticIndoorCam#directionPart"));
	self.ric.rotationPart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.realisticIndoorCam#rotationPart"));
	
	self.ric.startDirection = {};
	self.ric.startDirection.x, self.ric.startDirection.y, self.ric.startDirection.z = getRotation(self.ric.directionPart);
	self.ric.isOn = true;
end;
function realisticIndoorCamBeta2:delete()
end;
function realisticIndoorCamBeta2:mouseEvent(posX, posY, isDown, isUp, button)
end;
function realisticIndoorCamBeta2:keyEvent(unicode, sym, modifier, isDown)
end;
function realisticIndoorCamBeta2:update(dt)
	if self:getIsActive() then
		if self.ric.isOn then
			local ax, ay, az = getWorldTranslation(self.ric.directionPart);
			local bx = 0;
			local by = 1100000;
			local bz = 0;
			x, y, z = worldDirectionToLocal(getParent(self.ric.directionPart), bx-ax, by-ay, bz-az);
			setDirection(self.ric.directionPart, x, y, z, 0, 0, 1);		
		else
			setRotation(self.ric.directionPart, self.ric.startDirection.x, self.ric.startDirection.y, self.ric.startDirection.z);
		end;
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.RIC_ONOFF) then
				self.ric.isOn = not self.ric.isOn;
			end;
		end;
	end;
end;

function realisticIndoorCamBeta2:draw()	
	g_currentMission:addHelpButtonText(g_i18n:getText("TOGGLE_RIC"), InputBinding.RIC_ONOFF);
end;
