ManualIgnitionStatsEvent = {};
ManualIgnitionStatsEvent_mt = Class(ManualIgnitionStatsEvent, Event);

InitEventClass(ManualIgnitionStatsEvent, "ManualIgnitionStatsEvent");

function ManualIgnitionStatsEvent:emptyNew()
    local self = Event:new(ManualIgnitionStatsEvent_mt);
    self.className="ManualIgnitionStatsEvent";
    return self;
end;

function ManualIgnitionStatsEvent:new(vehicle)
    local self = ManualIgnitionStatsEvent:emptyNew()
    self.vehicle = vehicle;
    return self;
end;

function ManualIgnitionStatsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
	self.vehicle.fuelConsumption = streamReadFloat32(streamId);
	self.vehicle.distanceDriven = streamReadFloat32(streamId);
	self.vehicle.fuelUsed = streamReadFloat32(streamId);
	self.vehicle.runningTime = streamReadFloat32(streamId);
	if not connection:getIsServer() then
		g_server:broadcastEvent(ManualIgnitionStatsEvent:new(self.vehicle), nil, connection, self.vehicle);
	end;
end;

function ManualIgnitionStatsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteFloat32(streamId, self.vehicle.fuelConsumption);
	streamWriteFloat32(streamId, self.vehicle.distanceDriven);
	streamWriteFloat32(streamId, self.vehicle.fuelUsed);
	streamWriteFloat32(streamId, self.vehicle.runningTime);
end;

function ManualIgnitionStatsEvent.sendEvent(vehicle, isTransport)
	if g_server ~= nil then
		g_server:broadcastEvent(ManualIgnitionStatsEvent:new(vehicle), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(ManualIgnitionStatsEvent:new(vehicle));
	end;
end;

