mrFullPowershiftSetNextGearEvent = {};
mrFullPowershiftSetNextGearEvent_mt = Class(mrFullPowershiftSetNextGearEvent, Event);

InitEventClass(mrFullPowershiftSetNextGearEvent, "mrFullPowershiftSetNextGearEvent");

 
function mrFullPowershiftSetNextGearEvent:emptyNew()
	local self = Event:new(mrFullPowershiftSetNextGearEvent_mt);
	self.className="mrFullPowershiftSetNextGearEvent";
	return self;
end;

function mrFullPowershiftSetNextGearEvent:new(object, gearDown)
	local self = mrFullPowershiftSetNextGearEvent:emptyNew();
	self.gearDown = gearDown;
	self.object = object;
	return self;
end;

function mrFullPowershiftSetNextGearEvent:readStream(streamId, connection)
	--only the server receive the event
	local id = streamReadInt32(streamId);
	self.gearDown = streamReadBool(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function mrFullPowershiftSetNextGearEvent:writeStream(streamId, connection)
	--only the clients send this event
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.gearDown);
end;

function mrFullPowershiftSetNextGearEvent:run(connection)
	--only the server "run" this event (after reading it)	
	self.object:setNextGear(self.gearDown, true);	
end;