--
-- @Edit & Modernized: Northern_Strike
--
-- Copyright (C) 

MTZ892 = {};

function MTZ892.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function MTZ892:load(xmlFile)

	numparts4 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.parts4#count"), 0);
	self.parts4 = {};
    for i=1, numparts4 do
        local partnamei = string.format("vehicle.parts4.part%d", i);
        self.parts4[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
        setVisibility(self.parts4[i], false);
    end;
	self.parts4Active = false;

local rotationPartNodeautopoezdlper = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.autopoezdlper#index"));

    if rotationPartNodeautopoezdlper ~= nil then
        self.rotationPartautopoezdlper = {};
        self.rotationPartautopoezdlper.node = rotationPartNodeautopoezdlper;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.autopoezdlper#minRot"));
        self.rotationPartautopoezdlper.minRot = {};
        self.rotationPartautopoezdlper.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartautopoezdlper.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartautopoezdlper.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.autopoezdlper#maxRot"));
        self.rotationPartautopoezdlper.maxRot = {};
        self.rotationPartautopoezdlper.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartautopoezdlper.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartautopoezdlper.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartautopoezdlper.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.autopoezdlper#rotTime"), 2)*1000;
        self.rotationPartautopoezdlper.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.autopoezdlper#touchRotLimit"), 10));
    end;

	numparts3 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.parts3#count"), 0);
	self.parts3 = {};
    for i=1, numparts3 do
        local partnamei = string.format("vehicle.parts3.part%d", i);
        self.parts3[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
        setVisibility(self.parts3[i], false);
    end;
	self.parts3Active = false;

	numparts2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.parts2#count"), 0);
	self.parts2 = {};
    for i=1, numparts2 do
        local partnamei = string.format("vehicle.parts2.part%d", i);
        self.parts2[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
        setVisibility(self.parts2[i], false);
    end;
	self.parts2Active = false;

local rotationPartNodefrontlper = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.frontlper#index"));

    if rotationPartNodefrontlper ~= nil then
        self.rotationPartfrontlper = {};
        self.rotationPartfrontlper.node = rotationPartNodefrontlper;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.frontlper#minRot"));
        self.rotationPartfrontlper.minRot = {};
        self.rotationPartfrontlper.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartfrontlper.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartfrontlper.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.frontlper#maxRot"));
        self.rotationPartfrontlper.maxRot = {};
        self.rotationPartfrontlper.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartfrontlper.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartfrontlper.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartfrontlper.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.frontlper#rotTime"), 2)*1000;
        self.rotationPartfrontlper.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.frontlper#touchRotLimit"), 10));
    end;

local rotationPartNodebacklper = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.backlper#index"));

    if rotationPartNodebacklper ~= nil then
        self.rotationPartbacklper = {};
        self.rotationPartbacklper.node = rotationPartNodebacklper;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.backlper#minRot"));
        self.rotationPartbacklper.minRot = {};
        self.rotationPartbacklper.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbacklper.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbacklper.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.backlper#maxRot"));
        self.rotationPartbacklper.maxRot = {};
        self.rotationPartbacklper.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbacklper.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbacklper.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartbacklper.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.backlper#rotTime"), 2)*1000;
        self.rotationPartbacklper.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.backlper#touchRotLimit"), 10));
    end;

    numparts = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.parts#count"), 0);
	self.parts = {};
    for i=1, numparts do
        local partnamei = string.format("vehicle.parts.part%d", i);
        self.parts[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
        setVisibility(self.parts[i], false);
    end;
	self.partsActive = false;

 self.gearShifter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.gearShifter#index"));
 self.gearClutch = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.gearClutch#index"));

local rotationPartNodestrelka4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.strelka4#index"));

    if rotationPartNodestrelka4 ~= nil then
        self.rotationPartstrelka4 = {};
        self.rotationPartstrelka4.node = rotationPartNodestrelka4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.strelka4#minRot"));
        self.rotationPartstrelka4.minRot = {};
        self.rotationPartstrelka4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartstrelka4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartstrelka4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.strelka4#maxRot"));
        self.rotationPartstrelka4.maxRot = {};
        self.rotationPartstrelka4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartstrelka4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartstrelka4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartstrelka4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.strelka4#rotTime"), 2)*1000;
        self.rotationPartstrelka4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.strelka4#touchRotLimit"), 10));
    end;

local rotationPartNodestrelka3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.strelka3#index"));

    if rotationPartNodestrelka3 ~= nil then
        self.rotationPartstrelka3 = {};
        self.rotationPartstrelka3.node = rotationPartNodestrelka3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.strelka3#minRot"));
        self.rotationPartstrelka3.minRot = {};
        self.rotationPartstrelka3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartstrelka3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartstrelka3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.strelka3#maxRot"));
        self.rotationPartstrelka3.maxRot = {};
        self.rotationPartstrelka3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartstrelka3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartstrelka3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartstrelka3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.strelka3#rotTime"), 2)*1000;
        self.rotationPartstrelka3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.strelka3#touchRotLimit"), 10));
    end;


local rotationPartNodestrelka2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.strelka2#index"));

    if rotationPartNodestrelka2 ~= nil then
        self.rotationPartstrelka2 = {};
        self.rotationPartstrelka2.node = rotationPartNodestrelka2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.strelka2#minRot"));
        self.rotationPartstrelka2.minRot = {};
        self.rotationPartstrelka2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartstrelka2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartstrelka2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.strelka2#maxRot"));
        self.rotationPartstrelka2.maxRot = {};
        self.rotationPartstrelka2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartstrelka2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartstrelka2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartstrelka2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.strelka2#rotTime"), 2)*1000;
        self.rotationPartstrelka2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.strelka2#touchRotLimit"), 10));
    end;


local rotationPartNodestrelka1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.strelka1#index"));

    if rotationPartNodestrelka1 ~= nil then
        self.rotationPartstrelka1 = {};
        self.rotationPartstrelka1.node = rotationPartNodestrelka1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.strelka1#minRot"));
        self.rotationPartstrelka1.minRot = {};
        self.rotationPartstrelka1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartstrelka1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartstrelka1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.strelka1#maxRot"));
        self.rotationPartstrelka1.maxRot = {};
        self.rotationPartstrelka1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartstrelka1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartstrelka1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartstrelka1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.strelka1#rotTime"), 2)*1000;
        self.rotationPartstrelka1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.strelka1#touchRotLimit"), 10));
    end;

    local wiperAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiper#rootNode"));
    self.wiperAnimCharSet = 0;
    if wiperAnimRootNode ~= nil and wiperAnimRootNode ~= 0 then
        self.wiperAnimCharSet = getAnimCharacterSet(wiperAnimRootNode);
        if self.wiperAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperAnimCharSet, getXMLString(xmlFile, "vehicle.wiper#clip"));
            assignAnimTrackClip(self.wiperAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperAnimCharSet, 0, true);
            local wiperAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiper#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperAnimCharSet, 0, wiperAnimSpeedScale);
            self.wiperAnimDuration = getAnimClipDuration(self.wiperAnimCharSet, clip);
        end;
    end;
	self.isWiperActive = false;
	self.finishWiper = true;

	local rotationPartNoderuchnik = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ruchnik#index"));
    if rotationPartNoderuchnik ~= nil then
        self.rotationPartruchnik = {};
        self.rotationPartruchnik.node = rotationPartNoderuchnik;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartruchnik#minRot"));
        self.rotationPartruchnik.minRot = {};
        self.rotationPartruchnik.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchnik.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchnik.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.ruchnik#maxRot"));
        self.rotationPartruchnik.maxRot = {};
        self.rotationPartruchnik.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchnik.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchnik.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartruchnik.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.ruchnik#rotTime"), 2)*1000;
        self.rotationPartruchnik.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.ruchnik#touchRotLimit"), 10));
    end;


	handbrakeSoundFile = Utils.getFilename("Sounds/handbrake.wav", self.baseDirectory);
	self.handbrakeSoundId = createSample("handbrakeSound");
	loadSample(self.handbrakeSoundId, handbrakeSoundFile, false);	

       self.ventelator1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ventelator1#index"));

local rotationPartNodekluch = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kluch#index"));

    if rotationPartNodekluch ~= nil then
        self.rotationPartkluch = {};
        self.rotationPartkluch.node = rotationPartNodekluch;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kluch#minRot"));
        self.rotationPartkluch.minRot = {};
        self.rotationPartkluch.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkluch.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkluch.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kluch#maxRot"));
        self.rotationPartkluch.maxRot = {};
        self.rotationPartkluch.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkluch.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkluch.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartkluch.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kluch#rotTime"), 2)*1000;
        self.rotationPartkluch.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.kluch#touchRotLimit"), 10));
    end

	self.kardan1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kadranu.kardan1#index"));
	self.kardan2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kadranu.kardan2#index"));
	self.kardan3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kadranu.kardan3#index"));

	self.RotPoint = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kadranu.RotPoint#index"));


   local rotationPartNodeTanknadel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.benzin#index"));
    if rotationPartNodeTanknadel ~= nil then
        self.benzin = {};
        self.benzin.node = rotationPartNodeTanknadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.benzin#minRot"));
        self.benzin.minRot = {};
        self.benzin.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.benzin.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.benzin.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.benzin#maxRot"));
        self.benzin.maxRot = {};
        self.benzin.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.benzin.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.benzin.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.benzin.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.benzin#rotTime"), 2)*1000;
        self.benzin.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.benzin#touchRotLimit"), 10));
    end;

    local rotationPartNodeDrehzahl1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tahometr1#index"));
    if rotationPartNodeDrehzahl1 ~= nil then
        self.tahometr1 = {};
        self.tahometr1.node = rotationPartNodeDrehzahl1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tahometr1#minRot"));
        self.tahometr1.minRot = {};
        self.tahometr1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tahometr1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tahometr1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tahometr1#maxRot"));
        self.tahometr1.maxRot = {};
        self.tahometr1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tahometr1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tahometr1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.tahometr1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tahometr1#rotTime"), 2)*1000;
        self.tahometr1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tahometr1#touchRotLimit"), 10));
    end;

    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;

    self.nevid = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.nevid1#index"));
    self.nevid1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.nevid11#index"));

	self.SetDoorPanel = SpecializationUtil.callSpecializationsFunction("SetDoorPanel"); 
	self.DoorPanel = true;		      

    local armDownNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.armDown#index"));
    if armDownNode ~= nil then
        self.armDown = {};
        self.armDown.node = armDownNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armDown#minRot"));
        self.armDown.minRot = {};
        self.armDown.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armDown.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armDown.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armDown#maxRot"));
        self.armDown.maxRot = {};
        self.armDown.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armDown.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armDown.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.armDown.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.armDown#rotTime"), 2)*1000;
        self.armDown.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.armDown#touchRotLimit"), 10));
    end;

    local armUpNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.armUp#index"));
    if armUpNode ~= nil then
        self.armUp = {};
        self.armUp.node = armUpNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armUp#minRot"));
        self.armUp.minRot = {};
        self.armUp.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armUp.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armUp.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armUp#maxRot"));
        self.armUp.maxRot = {};
        self.armUp.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armUp.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armUp.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.armUp.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.armUp#rotTime"), 2)*1000;
        self.armUp.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.armUp#touchRotLimit"), 10));
    end;

    local rotBraceNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotBrace#index"));
    if rotBraceNode ~= nil then
        self.rotBrace = {};
        self.rotBrace.node = rotBraceNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotBrace#minRot"));
        self.rotBrace.minRot = {};
        self.rotBrace.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotBrace.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotBrace.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotBrace#maxRot"));
        self.rotBrace.maxRot = {};
        self.rotBrace.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotBrace.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotBrace.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotBrace.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotBrace#rotTime"), 2)*1000;
        self.rotBrace.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotBrace#touchRotLimit"), 10));
    end;

	local rotBrace2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotBrace2#index"));
    if rotBrace2Node ~= nil then
        self.rotBrace2 = {};
        self.rotBrace2.node = rotBrace2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotBrace2#minRot"));
        self.rotBrace2.minRot = {};
        self.rotBrace2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotBrace2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotBrace2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotBrace2#maxRot"));
        self.rotBrace2.maxRot = {};
        self.rotBrace2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotBrace2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotBrace2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotBrace2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotBrace2#rotTime"), 2)*1000;
        self.rotBrace2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotBrace2#touchRotLimit"), 10));
    end;

    local braceVertNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.braceVert#index"));
    if braceVertNode ~= nil then
        self.braceVert = {};
        self.braceVert.node = braceVertNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.braceVert#minTrans"));
        self.braceVert.minTrans = {};
        self.braceVert.minTrans[1] = Utils.getNoNil(x, 0);
        self.braceVert.minTrans[2] = Utils.getNoNil(y, 0);
        self.braceVert.minTrans[3] = Utils.getNoNil(z, 0);
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.braceVert#maxTrans"));
        self.braceVert.maxTrans = {};
        self.braceVert.maxTrans[1] = Utils.getNoNil(x, 0);
        self.braceVert.maxTrans[2] = Utils.getNoNil(y, 0);
        self.braceVert.maxTrans[3] = Utils.getNoNil(z, 0);
        self.braceVert.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.braceVert#transTime"), 2)*1000;
        self.braceVert.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.braceVert#touchTransLimit"), 10);
    end;

    self.numworkklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.workklights#count"), 0);
    self.workklights = {};
    for i=1, self.numworkklights do
        local workklightnamei = string.format("vehicle.workklights.workklight" .. "%d", i);
        self.workklights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, workklightnamei .. "#index"));
        setVisibility(self.workklights[i], false);
    end;	
	
	self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;
	self.brakelightsActive = false;
    self.braking = false;
	
	local doorsoSound = getXMLString(xmlFile, "vehicle.doorsoSound#file");
    if  doorsoSound ~= nil and  doorsoSound ~= "" then
        doorsoSound = Utils.getFilename( doorsoSound, self.baseDirectory); 
        self.doorsoSound = createSample(" doorsoSound");
        self.doorsoSoundPlaying = false;
        loadSample(self. doorsoSound, doorsoSound, false);
        self.doorsoSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.doorsoSound#volume"),1);
    end;
	
    self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;
	
	self.numFrontlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.frontlights#count"), 0);
    self.frontlights = {};
    for i=1, self.numFrontlights do
        local frontlightnamei = string.format("vehicle.frontlights.frontlight" .. "%d", i);
        self.frontlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, frontlightnamei .. "#index"));
        setVisibility(self.frontlights[i], false);
    end;	
 

	 self.numFarlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.farlights#count"), 0);
    self.farlights = {};
    for i=1, self.numFarlights do
        local farlightnamei = string.format("vehicle.farlights.farlight" .. "%d", i);
        self.farlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, farlightnamei .. "#index"));
        setVisibility(self.farlights[i], false);
    end;	
   
	
	local rotationPartNodebackwindow = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.backwindow#index"));
    if rotationPartNodebackwindow ~= nil then
        self.rotationPartbackwindow = {};
        self.rotationPartbackwindow.node = rotationPartNodebackwindow;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartbackwindow#minRot"));
        self.rotationPartbackwindow.minRot = {};
        self.rotationPartbackwindow.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbackwindow.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbackwindow.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.backwindow#maxRot"));
        self.rotationPartbackwindow.maxRot = {};
        self.rotationPartbackwindow.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbackwindow.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbackwindow.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartbackwindow.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.backwindow#rotTime"), 2)*1000;
        self.rotationPartbackwindow.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.backwindow#touchRotLimit"), 10));
    end;

     local rotationPartNoderightdoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rightdoor#index"));
    if rotationPartNoderightdoor ~= nil then
        self.rotationPartrightdoor = {};
        self.rotationPartrightdoor.node = rotationPartNoderightdoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartrightdoor#minRot"));
        self.rotationPartrightdoor.minRot = {};
        self.rotationPartrightdoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightdoor#maxRot"));
        self.rotationPartrightdoor.maxRot = {};
        self.rotationPartrightdoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartrightdoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor#rotTime"), 2)*1000;
        self.rotationPartrightdoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor#touchRotLimit"), 10));
    end;
	
	 local rotationPartNodeleftDoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.leftDoor#index"));
    if rotationPartNodeleftDoor ~= nil then
        self.rotationPartleftDoor = {};
        self.rotationPartleftDoor.node = rotationPartNodeleftDoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartleftDoor#minRot"));
        self.rotationPartleftDoor.minRot = {};
        self.rotationPartleftDoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftDoor#maxRot"));
        self.rotationPartleftDoor.maxRot = {};
        self.rotationPartleftDoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartleftDoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#rotTime"), 2)*1000;
        self.rotationPartleftDoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#touchRotLimit"), 10));
    end;
	local rotationPartNodeteto = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.teto#index"));
    if rotationPartNodeteto ~= nil then
        self.rotationPartteto = {};
        self.rotationPartteto.node = rotationPartNodeteto;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartteto#minRot"));
        self.rotationPartteto.minRot = {};
        self.rotationPartteto.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartteto.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartteto.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.teto#maxRot"));
        self.rotationPartteto.maxRot = {};
        self.rotationPartteto.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartteto.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartteto.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartteto.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.teto#rotTime"), 2)*1000;
        self.rotationPartteto.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.teto#touchRotLimit"), 10));
    end;
	local rotationPartNodeabl1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl1#index"));
    if rotationPartNodeabl1 ~= nil then
        self.rotationPartabl1 = {};
        self.rotationPartabl1.node = rotationPartNodeabl1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartabl1#minRot"));
        self.rotationPartabl1.minRot = {};
        self.rotationPartabl1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl1#maxRot"));
        self.rotationPartabl1.maxRot = {};
        self.rotationPartabl1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl1#rotTime"), 2)*1000;
        self.rotationPartabl1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl1#touchRotLimit"), 10));
    end;
local rotationPartNodeleft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.left#index"));
    if rotationPartNodeleft ~= nil then
        self.rotationPartleft = {};
        self.rotationPartleft.node = rotationPartNodeleft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartleft#minRot"));
        self.rotationPartleft.minRot = {};
        self.rotationPartleft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.left#maxRot"));
        self.rotationPartleft.maxRot = {};
        self.rotationPartleft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartleft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.left#rotTime"), 2)*1000;
        self.rotationPartleft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.left#touchRotLimit"), 10));
    end;
    local rotationPartNodeabl2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl2#index"));
    if rotationPartNodeabl2 ~= nil then
        self.rotationPartabl2 = {};
        self.rotationPartabl2.node = rotationPartNodeabl2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartabl2#minRot"));
        self.rotationPartabl2.minRot = {};
        self.rotationPartabl2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl2#maxRot"));
        self.rotationPartabl2.maxRot = {};
        self.rotationPartabl2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl2#rotTime"), 2)*1000;
        self.rotationPartabl2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl2#touchRotLimit"), 10));
    end;
    local rotationPartNodehidra1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hidra1#index"));
    if rotationPartNodehidra1 ~= nil then
        self.rotationParthidra1 = {};
        self.rotationParthidra1.node = rotationPartNodehidra1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParthidra1#minRot"));
        self.rotationParthidra1.minRot = {};
        self.rotationParthidra1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hidra1#maxRot"));
        self.rotationParthidra1.maxRot = {};
        self.rotationParthidra1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationParthidra1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra1#rotTime"), 2)*1000;
        self.rotationParthidra1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra1#touchRotLimit"), 10));
    end;
        local rotationPartNodehidra2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hidra2#index"));
    if rotationPartNodehidra2 ~= nil then
        self.rotationParthidra2 = {};
        self.rotationParthidra2.node = rotationPartNodehidra2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParthidra2#minRot"));
        self.rotationParthidra2.minRot = {};
        self.rotationParthidra2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hidra2#maxRot"));
        self.rotationParthidra2.maxRot = {};
        self.rotationParthidra2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationParthidra2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra2#rotTime"), 2)*1000;
        self.rotationParthidra2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra2#touchRotLimit"), 10));
    end;
      local rotationPartNodehidra3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hidra3#index"));
    if rotationPartNodehidra3 ~= nil then
        self.rotationParthidra3 = {};
        self.rotationParthidra3.node = rotationPartNodehidra3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParthidra3#minRot"));
        self.rotationParthidra3.minRot = {};
        self.rotationParthidra3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.hidra3#maxRot"));
        self.rotationParthidra3.maxRot = {};
        self.rotationParthidra3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParthidra3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParthidra3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationParthidra3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra3#rotTime"), 2)*1000;
        self.rotationParthidra3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.hidra3#touchRotLimit"), 10));
    end;
    self.motorStopSoundVolume2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#volume"), 1.0);
    hornSoundFile = Utils.getFilename("Sound/horn.wav", self.baseDirectory);
    self.hornSoundId = createSample("HupenSound");
    loadSample(self.hornSoundId, hornSoundFile, false);
    
    local motorMaxRpmStr = getXMLString(xmlFile, "vehicle.motor#maxRpm");
    local motorMaxRpm1, motorMaxRpm2, motorMaxRpm3 = Utils.getVectorFromString(motorMaxRpmStr);
    motorMaxRpm1 = Utils.getNoNil(motorMaxRpm1, 400);
    motorMaxRpm2 = Utils.getNoNil(motorMaxRpm2, 1300);
    motorMaxRpm3 = Utils.getNoNil(motorMaxRpm3, 2200);
    local motorMaxRpm = {motorMaxRpm1, motorMaxRpm2, motorMaxRpm3};
    self.motorMaxRpmLimit = motorMaxRpm;
    
	--[[Blinker start]]------------------------------------------------------------	
	turn1SoundFile = Utils.getFilename("Sound/turn1.wav", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	turn2SoundFile = Utils.getFilename("Sound/turn2.wav", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);	
	
    self.numTurnlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights#count"), 0);
    self.turnlights = {};
    for i=1, self.numTurnlights do
        local turnlightnamei = string.format("vehicle.turnlights.turnlight" .. "%d", i);
        self.turnlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei .. "#index"));
        setVisibility(self.turnlights[i], false);
    end;	
	self.turnlightsActive = false;
	
    self.numTurnlights2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights2#count"), 0);
    self.turnlights2 = {};
    for i=1, self.numTurnlights2 do
        local turnlightnamei2 = string.format("vehicle.turnlights2.turnlight" .. "%d", i);
        self.turnlights2[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei2 .. "#index"));
        setVisibility(self.turnlights2[i], false);
    end;	
	self.turnlightsActive2 = false;
--[[Blinker ende]]------------------------------------------------------------	

    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;
	
	self.frontlights.outs = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.frontlights.frontlight#src"));
	
	self.farlightsActive = false;
    self.frontlightsActive = false;
	self.workklightsActive = false;
    self.hornPlaying = false;
    

end;

function MTZ892:readStream(streamId, connection)
    self:SetDoorPanel(streamReadBool(streamId), true);
end;

function MTZ892:writeStream(streamId, connection)
    streamWriteBool(streamId, self.DoorPanel);
end;

function MTZ892:keyEvent(unicode, sym, modifier, isDown)

	if sym == self.keys.kirohydUp then
		self.armDownMax = isDown;
		self.armUpMax = isDown;
		self.rotBrace2Max = isDown;
		self.braceVertMax = isDown;
		self.armHydrMax = isDown;
	end;
	if sym == self.keys.kirohydDown then
		self.armDownMin = isDown;
		self.armUpMin = isDown;
		self.rotBrace2Min = isDown;
		self.braceVertMin = isDown;
		self.armHydrMin = isDown;
	end;

    if isDown and sym == self.keys.rundumleuchte then
      self.rundumleuchtenAn = not self.rundumleuchtenAn;
      for i=1, self.rundumleuchtenAnz do
        setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
      end;
    end;
	if isDown and sym == Input.KEY_8 then
		self.farlightsActive = not self.farlightsActive;
		self.frontlightsActive = false;
		self.workklightsActive = false;
	end;
    if isDown and sym == Input.KEY_0 then
		self.helpPanel = not self.helpPanel;
	end;
    if isDown and sym == Input.KEY_KP_8 then 
		self.rotationMaxbackwindow = not self.rotationMaxbackwindow;
	end; 
     if isDown and sym == Input.KEY_KP_4 then 
		self.rotationMaxrightdoor = not self.rotationMaxrightdoor;
	end; 
     if isDown and sym == Input.KEY_KP_7 then 
		self.rotationMaxleft = not self.rotationMaxleft;
	end; 
	 if isDown and sym == Input.KEY_KP_6 then 
		self.rotationMaxleftDoor = not self.rotationMaxleftDoor;
	end; 
	if isDown and sym == Input.KEY_KP_9 then 
		self.rotationMaxabl2 = not self.rotationMaxabl2;
	end;
	if isDown and sym == Input.KEY_v then 
		self.rotationMaxhidra1 = not self.rotationMaxhidra1;
	end;
	if isDown and sym == Input.KEY_v then 
		self.rotationMaxhidra2 = not self.rotationMaxhidra2;
	end;
        	if isDown and sym == Input.KEY_KP_0 then 
		self.rotationMaxhidra3 = not self.rotationMaxhidra3;
        end;
	if isDown and sym == Input.KEY_q then 
		self.rotationMaxhidra1 = not self.rotationMaxhidra1;
	end;
	if isDown and sym == Input.KEY_q then 
		self.rotationMaxhidra2 = not self.rotationMaxhidra2;
	end;
	--[[Blinker start]]------------------------------------------------------------	
--[[Blinker Rechts]]-----------------------------------------------------------
	if isDown and sym == Input.KEY_KP_3 then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsRight2Active = false;
		self.turnlightsActive2 = false;
		self.flashWarner = false;
	end;
--[[Warnblinker]]------------------------------------------------------------	
	if isDown and sym == Input.KEY_KP_2 then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
		self.flashWarner = not self.flashWarner;
	end;
--[[Blinker Links]]-----------------------------------------------------------
	if isDown and sym == Input.KEY_KP_1 then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsLeft2Active = false;
		self.turnlightsActive = false;
		self.flashWarner = false;
	end;	
--[[Blinker ende]]------------------------------------------------------------

end;


function MTZ892:update(dt)

   if self.parts4Active then
		for i=1, numparts4 do
			setVisibility(self.parts4[i], self.parts4Active);
		end;
	        else
		for i=1, numparts4 do
			setVisibility(self.parts4[i], self.parts4Active, false);
	    end;	
    end;

	if self.rotationPartautopoezdlper ~= nil then
		local x, y, z = getRotation(self.rotationPartautopoezdlper.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartautopoezdlper.maxRot, self.rotationPartautopoezdlper.minRot, 3, self.rotationPartautopoezdlper.rotTime, dt, not self.rotationMaxautopoezdlper);
		setRotation(self.rotationPartautopoezdlper.node, unpack(newRot));
	end;

   if self.parts3Active then
		for i=1, numparts3 do
			setVisibility(self.parts3[i], self.parts3Active);
		end;
	        else
		for i=1, numparts3 do
			setVisibility(self.parts3[i], self.parts3Active, false);
	    end;	
    end;

   if self.parts2Active then
		for i=1, numparts2 do
			setVisibility(self.parts2[i], self.parts2Active);
		end;
	        else
		for i=1, numparts2 do
			setVisibility(self.parts2[i], self.parts2Active, false);
	    end;	
    end;

	if self.rotationPartfrontlper ~= nil then
		local x, y, z = getRotation(self.rotationPartfrontlper.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartfrontlper.maxRot, self.rotationPartfrontlper.minRot, 3, self.rotationPartfrontlper.rotTime, dt, not self.rotationMaxfrontlper);
		setRotation(self.rotationPartfrontlper.node, unpack(newRot));
	end;

	if self.rotationPartbacklper ~= nil then
		local x, y, z = getRotation(self.rotationPartbacklper.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbacklper.maxRot, self.rotationPartbacklper.minRot, 3, self.rotationPartbacklper.rotTime, dt, not self.rotationMaxbacklper);
		setRotation(self.rotationPartbacklper.node, unpack(newRot));
	end;

  if self.partsActive then
		for i=1, numparts do
			setVisibility(self.parts[i], self.partsActive);
		end;
	        else
		for i=1, numparts do
			setVisibility(self.parts[i], self.partsActive, false);
	    end;
	end;

	local speed = self.lastSpeed*3600;
     if self.gearShifter ~= nil then
          if self.movingDirection < 0 then
               setRotation(self.gearShifter, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));
          else     
--0--
          if speed >= -0.5 and speed < 0.5 then
               setRotation(self.gearShifter, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));
--1---
          elseif speed >= 0.5 and speed < 5 then
               setRotation(self.gearShifter, Utils.degToRad(4.3), Utils.degToRad(0), Utils.degToRad(5.9));
--2---
          elseif speed >= 5 and speed < 12 then
               setRotation(self.gearShifter, Utils.degToRad(-15.9), Utils.degToRad(0), Utils.degToRad(0));
--3---
          elseif speed >= 12 and speed < 17 then
               setRotation(self.gearShifter, Utils.degToRad(12.6), Utils.degToRad(0), Utils.degToRad(-6.2));
--4---
          elseif speed >= 17 and speed < 22 then
               setRotation(self.gearShifter, Utils.degToRad(-17), Utils.degToRad(0), Utils.degToRad(-6.2));
--5---
          elseif speed >= 22 then
               setRotation(self.gearShifter, Utils.degToRad(15.9), Utils.degToRad(0), Utils.degToRad(0));
--Back---
          elseif speed < -0.5 then
               setRotation(self.gearShifter, Utils.degToRad(-19.6), Utils.degToRad(0), Utils.degToRad(6.15));
          end;
     end;
  end;

--Clutch--
     if self.gearClutch ~= nil then
          if self.movingDirection < 0 then
               setRotation(self.gearClutch, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));
          else     
          if speed >= 0.4 and speed < 0.6 then
               setRotation(self.gearClutch, Utils.degToRad(35), Utils.degToRad(0), Utils.degToRad(0));

          elseif speed >= 0.6 and speed < 4.8 then
               setRotation(self.gearClutch, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));

          elseif speed >= 4.8 and speed < 5.2 then
               setRotation(self.gearClutch, Utils.degToRad(35), Utils.degToRad(0), Utils.degToRad(0));

          elseif speed >= 5.2 and speed < 11.8 then
               setRotation(self.gearClutch, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));

          elseif speed >= 11.8 and speed < 12.4 then
               setRotation(self.gearClutch, Utils.degToRad(35), Utils.degToRad(0), Utils.degToRad(0));

          elseif speed >= 12.4 and speed < 16.8 then
               setRotation(self.gearClutch, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));

          elseif speed >= 16.8 and speed < 17.8 then
               setRotation(self.gearClutch, Utils.degToRad(35), Utils.degToRad(0), Utils.degToRad(0));

          elseif speed >= 17.8 and speed < 21.8 then
               setRotation(self.gearClutch, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));

          elseif speed >= 21.8 and speed < 22.8 then
               setRotation(self.gearClutch, Utils.degToRad(35), Utils.degToRad(0), Utils.degToRad(0));

          elseif speed >= 22.8 then
               setRotation(self.gearClutch, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));

          end;
          end;
     end;

	if self.rotationPartruchnik  ~= nil then
		local x, y, z = getRotation(self.rotationPartruchnik .node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartruchnik.maxRot, self.rotationPartruchnik.minRot, 3, self.rotationPartruchnik.rotTime, dt, not self.rotationMaxruchnik);
		setRotation(self.rotationPartruchnik .node, unpack(newRot));
	end;

if self.isEntered then
	if self.handbrake then
		self.motor.backwardGearRatio = 0;
		self.motor.forwardGearRatios = {0, 0, 0};
		self.motor.brakeForce = 100;
	else
		self.motor.backwardGearRatio = 2.1;
		self.motor.forwardGearRatios = {2.5, 2.5, 2.5};
	end;
end;

	if self.isMotorStarted then
         		rotate(self.ventelator1, 0, 0, dt*0.01 );		
	end;

	if self.isEntered then
		if self.isMotorStarted then
			self.rotationMaxkluch = true;
			self.rotationMaxstrelka1 = true;
			self.rotationMaxstrelka2 = true;
			self.rotationMaxstrelka3 = true;
			self.rotationMaxstrelka4 = true;
		else
			self.rotationMaxkluch = false;
			self.rotationMaxstrelka1 = false;
			self.rotationMaxstrelka2 = false;
			self.rotationMaxstrelka3 = false;
			self.rotationMaxstrelka4 = false;
		end;
	end;

	if self.rotationPartkluch ~= nil then
		local x, y, z = getRotation(self.rotationPartkluch.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartkluch.maxRot, self.rotationPartkluch.minRot, 3, self.rotationPartkluch.rotTime, dt, not self.rotationMaxkluch);
		setRotation(self.rotationPartkluch.node, unpack(newRot));
	end;

	if self.rotationPartstrelka1 ~= nil then
		local x, y, z = getRotation(self.rotationPartstrelka1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartstrelka1.maxRot, self.rotationPartstrelka1.minRot, 3, self.rotationPartstrelka1.rotTime, dt, not self.rotationMaxstrelka1);
		setRotation(self.rotationPartstrelka1.node, unpack(newRot));
	end;

	if self.rotationPartstrelka2 ~= nil then
		local x, y, z = getRotation(self.rotationPartstrelka2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartstrelka2.maxRot, self.rotationPartstrelka2.minRot, 3, self.rotationPartstrelka2.rotTime, dt, not self.rotationMaxstrelka2);
		setRotation(self.rotationPartstrelka2.node, unpack(newRot));
	end;

	if self.rotationPartstrelka3 ~= nil then
		local x, y, z = getRotation(self.rotationPartstrelka3.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartstrelka3.maxRot, self.rotationPartstrelka3.minRot, 3, self.rotationPartstrelka3.rotTime, dt, not self.rotationMaxstrelka3);
		setRotation(self.rotationPartstrelka3.node, unpack(newRot));
	end;

	if self.rotationPartstrelka4 ~= nil then
		local x, y, z = getRotation(self.rotationPartstrelka4.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartstrelka4.maxRot, self.rotationPartstrelka4.minRot, 3, self.rotationPartstrelka4.rotTime, dt, not self.rotationMaxstrelka4);
		setRotation(self.rotationPartstrelka4.node, unpack(newRot));
	end;

	if self.isMotorStarted then
	   self.PointRot = getRotation(self.RotPoint)

       setRotation(self.kardan1,0 ,0 ,self.PointRot);
       setRotation(self.kardan2,0 ,0 ,self.PointRot);
       setRotation(self.kardan3,0 ,0 ,self.PointRot);
	   end;

	if self.isMotorStarted then
		if self.benzin ~= nil then
			local x, y, z = getRotation(self.benzin.node);
			y = ((self.benzin.maxRot[2] - self.benzin.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.benzin.minRot[2];
			setRotation(self.benzin.node, x, y ,z);
		end;
	else
			setRotation(self.benzin.node, 0, 0 ,0);
	end;

	if self.isMotorStarted then
	local maxDrehzahl = 2000;
			if self.tahometr1 ~= nil then
				local x, y, z = getRotation(self.tahometr1.node);
				y = ((self.tahometr1.maxRot[2] - self.tahometr1.minRot[2]) / maxDrehzahl) * self.motor.lastMotorRpm + self.tahometr1.minRot[2];
				setRotation(self.tahometr1.node, x, y ,z);
			end;
	else
			setRotation(self.tahometr1.node, 0, 0 ,0);
	end;

		local doRotate = self.armDownMax or self.armDownMin 
		if self.armDown ~= nil and doRotate then
        	local x, y, z = getRotation(self.armDown.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.armDown.maxRot, self.armDown.minRot, 3, self.armDown.rotTime, dt, not self.armDownMax);
        	setRotation(self.armDown.node, unpack(newRot));
		end;

		local doRotate = self.armUpMax or self.armUpMin 
		if self.armUp ~= nil and doRotate then
			local x, y, z = getRotation(self.armUp.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.armUp.maxRot, self.armUp.minRot, 3, self.armUp.rotTime, dt, not self.armUpMax);
			setRotation(self.armUp.node, unpack(newRot));
		end;

		local doRotate = self.rotBraceMax or self.rotBraceMin 
		if self.rotBrace ~= nil and doRotate then
			local x, y, z = getRotation(self.rotBrace.node);		
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotBrace.maxRot, self.rotBrace.minRot, 3, self.rotBrace.rotTime, dt, not self.rotBraceMax);
			setRotation(self.rotBrace.node, unpack(newRot));
		end;

		local doRotate = self.rotBrace2Max or self.rotBrace2Min 
		if self.rotBrace2 ~= nil and doRotate then
			local x, y, z = getRotation(self.rotBrace2.node);		
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotBrace2.maxRot, self.rotBrace2.minRot, 3, self.rotBrace2.rotTime, dt, not self.rotBrace2Max);
			setRotation(self.rotBrace2.node, unpack(newRot));
		end;
		
		local doTranslate = self.braceVertMax or self.braceVertMin 
		if self.braceVert ~= nil and doTranslate then 
			local x, y, z = getTranslation(self.braceVert.node); 
			local trans = {x,y,z}; 
			local newTrans = Utils.getMovedLimitedValues(trans, self.braceVert.maxTrans, self.braceVert.minTrans, 3, self.braceVert.transTime, dt, not self.braceVertMax); 
			setTranslation(self.braceVert.node, unpack(newTrans)); 
		end;

         if self:getIsActiveForInput() and self:getIsActiveForSound() and self.DoorPanel then
             if not self.doorsoSoundPlaying then 
              setSamplePitch(self.doorso, self.doorsoSoundPitchOffset);
              playSample(self.doorso, 1, 1, 0);
               self.doorsoSoundPlaying = true; 
           else 
                stopSample(self. doorsoSound); 
                self.doorsoSoundPlaying = false; 
             end;  
          end;

if self.inrange or self.isEntered then
		if InputBinding.hasEvent(InputBinding.DOOR) then
			self:SetDoorPanel(not self.DoorPanel);
		end;
end;

if self.inrange then
	if InputBinding.hasEvent (InputBinding.KAPOT) then
		self.rotationMaxteto = not self.rotationMaxteto;
	end;
end;

    if self.gang0 and self.isEntered then
			if InputBinding.hasEvent (InputBinding.reduktork) then
		setVisibility(self.nevid, self.drawnevid, true);
		setVisibility(self.nevid1, self.drawnevid1, true);
		self.reduktor = true;
			end;

			if InputBinding.hasEvent (InputBinding.reduktorr) then
		setVisibility(self.nevid, self.drawnevid, false);
		setVisibility(self.nevid1, self.drawnevid1, false);
		self.reduktor = false;
			end;

		if self.reduktor then
		else
		end;
     end;


	if self.isEntered then
	end;

	if self.inrange or self.isEntered then
	end;

	if self.inrange then
	end;
	
	    if self.rotationPartbackwindow ~= nil then
		   local x, y, z = getRotation(self.rotationPartbackwindow.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbackwindow.maxRot, self.rotationPartbackwindow.minRot, 3, self.rotationPartbackwindow.rotTime, dt, not self.rotationMaxbackwindow);
		   setRotation(self.rotationPartbackwindow.node, unpack(newRot));
        end;

        if self.rotationPartleftDoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartleftDoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartleftDoor.maxRot, self.rotationPartleftDoor.minRot, 3, self.rotationPartleftDoor.rotTime, dt, not self.rotationMaxleftDoor);
		   setRotation(self.rotationPartleftDoor.node, unpack(newRot));
        end;
    
       if self.rotationPartteto ~= nil then
		   local x, y, z = getRotation(self.rotationPartteto.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartteto.maxRot, self.rotationPartteto.minRot, 3, self.rotationPartteto.rotTime, dt, not self.rotationMaxteto);
		   setRotation(self.rotationPartteto.node, unpack(newRot));
        end;
        
	    if self.rotationPartrightdoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartrightdoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartrightdoor.maxRot, self.rotationPartrightdoor.minRot, 3, self.rotationPartrightdoor.rotTime, dt, not self.rotationMaxrightdoor);
		   setRotation(self.rotationPartrightdoor.node, unpack(newRot));
        end;
		if self.rotationPartabl1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartabl1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartabl1.maxRot, self.rotationPartabl1.minRot, 3, self.rotationPartabl1.rotTime, dt, not self.rotationMaxabl1);
		   setRotation(self.rotationPartabl1.node, unpack(newRot));
        end;
	if self.rotationPartleft ~= nil then
		local x, y, z = getRotation(self.rotationPartleft.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartleft.maxRot, self.rotationPartleft.minRot, 3, self.rotationPartleft.rotTime, dt, not self.rotationMaxleft);
		setRotation(self.rotationPartleft.node, unpack(newRot));
	end;
        if self.rotationPartabl2 ~= nil then
		   local x, y, z = getRotation(self.rotationPartabl2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartabl2.maxRot, self.rotationPartabl2.minRot, 3, self.rotationPartabl2.rotTime, dt, not self.rotationMaxabl2);
		   setRotation(self.rotationPartabl2.node, unpack(newRot));
        end;
        if self.rotationParthidra1 ~= nil then
		   local x, y, z = getRotation(self.rotationParthidra1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationParthidra1.maxRot, self.rotationParthidra1.minRot, 3, self.rotationParthidra1.rotTime, dt, not self.rotationMaxhidra1);
		   setRotation(self.rotationParthidra1.node, unpack(newRot));
        end;
        if self.rotationParthidra2 ~= nil then
		   local x, y, z = getRotation(self.rotationParthidra2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationParthidra2.maxRot, self.rotationParthidra2.minRot, 3, self.rotationParthidra2.rotTime, dt, not self.rotationMaxhidra2);
		   setRotation(self.rotationParthidra2.node, unpack(newRot));
        end;
        if self.rotationParthidra3 ~= nil then
		   local x, y, z = getRotation(self.rotationParthidra3.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationParthidra3.maxRot, self.rotationParthidra3.minRot, 3, self.rotationParthidra3.rotTime, dt, not self.rotationMaxhidra3);
		   setRotation(self.rotationParthidra3.node, unpack(newRot));
	
	
	    if self.isEntered then
        if self.workklightsActive then
		   for i=1, self.numworkklights do
		   local workklight = self.workklights[i];
		   setVisibility(workklight, self.workklightsActive);
		end;
	else
		for i=1, self.numworkklights do
			local workklight = self.workklights[i];
			setVisibility(workklight, self.workklightsActive, false);
		end;
	end;
	end;
	    
		if self.isEntered then
		  if self.frontlightsActive then
		   for i=1, self.numFrontlights do
		   local frontlight = self.frontlights[i];
		   setVisibility(frontlight, self.frontlightsActive);
		end;
	else
		for i=1, self.numFrontlights do
			local frontlight = self.frontlights[i];
			setVisibility(frontlight, self.frontlightsActive, false);
			setVisibility(self.frontlights.outs, true);
		end;
	end;
	end;
	end;
	
		if self.isEntered then
        if self.farlightsActive then
		   for i=1, self.numFarlights do
		   local farlight = self.farlights[i];
		   setVisibility(farlight, self.farlightsActive);
		end;
	else 
	    if not self.farlightsActive then
		for i=1, self.numFarlights do
			local farlight = self.farlights[i];
			setVisibility(farlight, self.farlightsActive, false);
		end;
	end;
 end;
 
        if self.isEntered then
          if self.frontlightsActive then
            setVisibility(self.frontlights.outs, false);
          else
            setVisibility(self.frontlights.outs, true);
          end;
        end;

        inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);

        if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
        end;
			
		if self.isEntered ~= nil then
		if self.brakelightsActive then
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive);
			end;
		else
			for i=1, self.numbrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive, false);
			end;
		end;
		if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		
			self.brakelightsActive = true;
			self.braking = true;
		else
			self.brakelightsActive = false;
			self.braking = false;
		end;
    end;
		  
        if self.hornPlaying then
            playSample(self.hornSoundId, 1, 0.5, 0);
        else
            stopSample(self.hornSoundId);
        end;

        if self.rundumleuchtenAn then
          for i=1, self.rundumleuchtenAnz do
            rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
          end;
        end;
        
		if g_currentMission.environment ~= nil and g_currentMission.environment.dayNightCycle and
              (g_currentMission.environment.dayTime > (20.5*1000*60*60) or g_currentMission.environment.dayTime < (5.5*1000*60*60)) and
              not self.lightsActive and self.isHired and not self.steeringEnabled then
		self.lightsActive = true;
	end;

	if not self.isHired and self.lightsActive and not self.isEntered or not g_currentMission.environment.dayNightCycle then
		self.lightsActive = false;
	end;


    for k, light in pairs(self.lights) do
        setVisibility(light, self.lightsActive);
    end; 
    
	end;
	
	
--[[Blinker start]]------------------------------------------------------------
	    if self.flash then
		    if self.delayOn >= 0 then
			    self.delayOn = self.delayOn -dt;
		    end;
		    if not self.flashlightsRightActive then
			    if self.delayOn < 0 then
				    self.delayOff = 500;
				    self.flashlightsRightActive = true;
				    self.flashlightsLeftActive = true;
			    	self.flashlightsWarnerActive = true;
				    self.turnlightsActive2 = true;
			    	self.turnlightsActive = true;
				    playSample(self.turn1, 1, 0.7, 0);
			    end;
		    end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashlightsLeftActive = false;
				self.flashlightsRightActive = false;
				self.flashlightsWarnerActive = false;
				self.turnlightsActive2 = false;
				self.turnlightsActive = false;
				playSample(self.turn2, 1, 0.7, 0);
			end;
		end;
	  end;

	    if self.flashRight then
		    if self.delayOnRight >= 0 then
			    self.delayOnRight = self.delayOnRight -dt;
		    end;
		    if not self.flashlightsRightActive then
			    if self.delayOnRight < 0 then
				    self.delayOffRight = 500;
				    self.flashlightsRightActive = true;
				    self.turnlightsActive2 = true;
				    playSample(self.turn1,1,0.7,0);
			    end;
		    end;
		    if self.delayOffRight >= 0 then
			   self.delayOffRight = self.delayOffRight -dt;
		    end;
		    if self.flashlightsRightActive then
			    if self.delayOffRight < 0 then
				    self.delayOnRight = 500;
				    self.flashlightsRightActive = false;
				    self.turnlightsActive2 = false;
				    playSample(self.turn2,1,0.7,0);
			    end;
		    end;
	    else
		    if not self.flashWarner then
			    self.turnlightsActive2 = false;
		    end;
	    end;

		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					self.turnlightsActive = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					self.turnlightsActive = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.turnlightsActive = false;
			end;
		end;

		if self.turnlightsActive then
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive);
			end;
		else
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive, false);
			end;
		end;
    	if self.turnlightsActive2 then
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2);
			end;
		else
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2, false);
			end;
		end;
	
--[[Blinker ende]]------------------------------------------------------------

end;

function MTZ892:updateTick(dt)

		if not self.finishWiper then
			if getAnimTrackTime(self.wiperAnimCharSet, 0) % self.wiperAnimDuration <= 100 then
				setAnimTrackTime(self.wiperAnimCharSet, 0, 0.0);
				disableAnimTrack(self.wiperAnimCharSet, 0);			
				self.finishWiper = true;
			end;			
		end;
		
		if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
			if not self.isWiperActive then
				enableAnimTrack(self.wiperAnimCharSet, 0);
				self.isWiperActive = true;
			end;
		else
			if self.isWiperActive then
				self.isWiperActive = false;
				self.finishWiper = false;
			end;
		end;

if g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement 
		local nearestDistance = 4.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode); 
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.inrange = true; 
		else
			self.inrange = false; 
		end;
	end;
end;

function MTZ892:draw()
	if self.handbrake then
		setTextBold(true);
		setTextColor(1,0,0,1);
		if self.input == -1 then
			setTextBold(true);
			setTextColor(1,0,0,1);
			renderText(0.3, 0.3, 0.05, "Handbrake ON!");
		end;
	end;
end;

function MTZ892:SetDoorPanel(isDoorPanel,noEventSend)
	SetDoorPanelEvent.sendEvent(self, isDoorPanel, noEventSend);
	if isDoorPanel then
		self.DoorPanel = true;
	else
		self.DoorPanel = false;
	end;
end;

function MTZ892:onEnter()
	if self.isWiperActive then
		enableAnimTrack(self.wiperAnimCharSet, 0);	
	end;
    Utils.setEmittingState(self.exhaustParticleLow, false);
end;

function MTZ892:onLeave()
	if self.isWiperActive then
		disableAnimTrack(self.wiperAnimCharSet, 0);	
	end;
		self.DoorPanel = false;
    self.rundumleuchtenAn = false;
    for i=1, self.rundumleuchtenAnz do
       setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
    end;
    self.workklightsActive = false;
	
	if self.doorsoSound ~= nil then
        stopSample(self.doorsoSound);
    end;
	
end;

function MTZ892:delete()   
end;


function MTZ892:mouseEvent(posX, posY, isDown, isUp, button)
end;

function key_convert(key)
    if key ~= nil then 
	    local keyname = "";
	    if key > 32 and key < 123 then
	    	keyname = string.upper(string.char(key));
	    elseif key > 255 and key < 266 then
	    	keyname = "NUM "..string.char(key-208);
	    else 
	    	keyname = "";
	    end;
	    return(keyname);
	  end;
end;

function MTZ892:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

