SetHasRopesEvent = {};
SetHasRopesEvent_mt = Class(SetHasRopesEvent, Event);

InitEventClass(SetHasRopesEvent, "SetHasRopesEvent");

function SetHasRopesEvent:emptyNew()
    local self = Event:new(SetHasRopesEvent_mt);
    self.className="SetHasRopesEvent";
    return self;
end;

function SetHasRopesEvent:new(vehicle, isLoadedWithRopes)
    local self = SetHasRopesEvent:emptyNew()
    self.vehicle = vehicle;
	self.isLoadedWithRopes = isLoadedWithRopes;
    return self;
end;

function SetHasRopesEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isLoadedWithRopes = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetHasRopesEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isLoadedWithRopes);
end;

function SetHasRopesEvent:run(connection)   
	self.vehicle:SetHasRopes(self.isLoadedWithRopes, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetHasRopesEvent:new(self.vehicle, self.isLoadedWithRopes), nil, connection, self.vehicle);
    end;
end;

function SetHasRopesEvent.sendEvent(vehicle, isLoadedWithRopes, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetHasRopesEvent:new(vehicle, isLoadedWithRopes), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetHasRopesEvent:new(vehicle, isLoadedWithRopes));
		end;
	end;
end;


SetDoorPanelEvent = {};
SetDoorPanelEvent_mt = Class(SetDoorPanelEvent, Event);

InitEventClass(SetDoorPanelEvent, "SetDoorPanelEvent");

function SetDoorPanelEvent:emptyNew()
    local self = Event:new(SetDoorPanelEvent_mt);
    self.className="SetDoorPanelEvent";
    return self;
end;

function SetDoorPanelEvent:new(vehicle, isDoorState)
    local self = SetDoorPanelEvent:emptyNew()
    self.vehicle = vehicle;
	self.isDoorPanelState = isDoorState;
    return self;
end;

function SetDoorPanelEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isDoorPanelState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetDoorPanelEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isDoorPanelState);
end;

function SetDoorPanelEvent:run(connection)   
	self.vehicle:SetDoorPanel(self.isDoorPanelState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetDoorPanelEvent:new(self.vehicle, self.isDoorPanelState), nil, connection, self.vehicle);
    end;
end;

function SetDoorPanelEvent.sendEvent(vehicle, isDoorState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetDoorPanelEvent:new(vehicle, isDoorState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetDoorPanelEvent:new(vehicle, isDoorState));
		end;
	end;
end;


setOverFlowEvent = {};
setOverFlowEvent_mt = Class(setOverFlowEvent, Event);

InitEventClass(setOverFlowEvent, "setOverFlowEvent");

function setOverFlowEvent:emptyNew()
    local self = Event:new(setOverFlowEvent_mt);
    self.className="setOverFlowEvent";
    return self;
end;

function setOverFlowEvent:new(object, OverFlow)
    local self = setOverFlowEvent:emptyNew()
    self.object = object;
    self.OverFlow = OverFlow;
    return self;
end;

function setOverFlowEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.OverFlow = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function setOverFlowEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteBool(streamId, self.OverFlow);
end;

function setOverFlowEvent:run(connection)
    self.object:setOverFlow(self.OverFlow, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(setOverFlowEvent:new(self.object, self.OverFlow), nil, connection, self.object);
    end;
end;