--
-- Show/Hide Frontloader
-- 
--
-- @author SndGrdn
-- @date  11/07/2011
-- 1st .lua script for FS2011
-- 
-- Mega Thanks go out to Xentro...You are the man!
--

ShowHideFL = {};

function ShowHideFL.prerequisitesPresent(specializations)
	return true;
end;

function ShowHideFL:load(xmlFile)
	self.setFLloc = SpecializationUtil.callSpecializationsFunction("setFLloc");
	self.FLloc = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.FLRoot#index"));
	self.FLlocActive = false;
	setVisibility(self.FLloc, false);
end;

function ShowHideFL:delete()
end;

function ShowHideFL:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHideFL:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHideFL:readStream(streamId, connection)
	local state = streamReadBool(streamId);
	self:setFLloc(state,true);
end;
	
function ShowHideFL:writeStream(streamId, connection)
	streamWriteBool(streamId, self.FLlocActive);
end;

function ShowHideFL:update(dt)
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.ShowFrontloader) then
				self:setFLloc(not self.FLlocActive); 
			end;
		end;
	end;	
end;

function ShowHideFL:draw()
    -- Draws HUD Text
	if g_currentMission.showHelpText then
		g_currentMission:addHelpButtonText(g_i18n:getText("EnableFrontloader"), InputBinding.ShowFrontloader);
	end;
end;

function ShowHideFL:onDetach()
	if self.FLlocActive then
		self:setFLloc(false); 
	end;
end;

function ShowHideFL:setFLloc(state,noEventSend)
	self.FLlocActive = state;
	if self.FLlocActive then
		setVisibility(self.FLloc, true);
		-- do true stuff here
	else
		setVisibility(self.FLloc, false);
		-- do false stuff here 
	end;
	setFLlocEvent.sendEvent(self,state,noEventSend);
end;


-- Event --
setFLlocEvent = {};
setFLlocEvent_mt = Class(setFLlocEvent, Event);
InitEventClass(setFLlocEvent, "setFLlocEvent");

function setFLlocEvent:emptyNew()
    local self = Event:new(setFLlocEvent_mt);
    self.className="setFLlocEvent";
    return self;
end;

function setFLlocEvent:new(object, state)
	local self = setFLlocEvent:emptyNew()
	self.object = object;
	self.state = state;
	return self;
end;

function setFLlocEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.state = streamReadBool(streamId);
    self:run(connection);
end;

function setFLlocEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function setFLlocEvent:run(connection)
	self.object:setFLloc(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(setFLlocEvent:new(self.object, self.state), nil, connection, self.object);
	end;	
end;

function setFLlocEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(setFLlocEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(setFLlocEvent:new(vehicle, state));
		end;
	end;
end;