--
-- Rotors.lua
--
-- @author MRA-Modding(Alex2009)
-- @website www.alex2009.de, www.mra-modding.de
-- @date 19.04.2012
--
--Modifikation erst nach rcksprache mit dem Autor(Alex2009) erlaubt.
--Modification allowed only after consultation with the author(Alex2009).
--

Rotor = {}; 

function Rotor.prerequisitesPresent(specializations)
    return true;
end;
function Rotor:load(xmlFile)
    self.rotors = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.rotors.rotor(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
             break;
        end;
        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"),0.003);
        if node ~= nil then
            table.insert(self.rotors, {node=node,speed=speed});
        end;
        i = i + 1;
    end;
end;

function Rotor:delete()
end;

function Rotor:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Rotor:keyEvent(unicode, sym, modifier, isDown)
end;

function Rotor:update(dt)
end;

function Rotor:updateTick(dt)
    if self.isMotorStarted then
        for _,v in pairs(self.rotors) do
            if v.node ~= nil then
                rotate(v.node,v.speed*dt,0,0)
            end;
        end;
	end;
end;

function Rotor:onLeave()
end;

function Rotor:draw()
end;
