-- LUA fr realistisches Partikelsystem am Auspuff
-- basiert im Grundsatz dynamicExhaustSystem.lua von Face bzw. dessen Shader ausm dem Kirovets K 700A
--
-- by modelleicher
-- www.schwabenmodding.bplaced.net


realExhaustParticleSystem = {};

function realExhaustParticleSystem.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function realExhaustParticleSystem:load(xmlFile)
	self.reps = {};
	
	self.reps.minAlpha = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realExhaustParticleSystem#minAlpha"), 0.1);
	self.reps.maxAlpha = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.realExhaustParticleSystem#maxAlpha"), 1);
	self.reps.parameter = getXMLString(xmlFile, "vehicle.realExhaustParticleSystem#parameter");

	self.reps.realAlpha = self.reps.minAlpha;
	self.reps.isAcc = false;
	self.reps.accBackup = self.motor.minRpm;
	
	self.klappe = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.realExhaustParticleSystem#klappe"));
	

	if self.motorStartSound ~= nil then
		self.startSequenze = true;
		self.startDuration = getSampleDuration(self.motorStartSound);
		self.whiteOutDuration = self.startDuration - (self.startDuration/2.4);
		self.minDiff = 0;
		self.maxDiff = 0.9;
		self.diff = 0;
		self.curDuration = 0;
	end;
end;
function realExhaustParticleSystem:startMotor(noEventSend)
	self.playStartSequenze = true;
end;
function realExhaustParticleSystem:delete()
end;
function realExhaustParticleSystem:mouseEvent(posX, posY, isDown, isUp, button)
end;
function realExhaustParticleSystem:keyEvent(unicode, sym, modifier, isDown)
end;
function realExhaustParticleSystem:update(dt)
	if self:getIsActiveForInput() or self.isServer and self:getIsActive() then
	
		if self.isMotorStarted then
			if self.startSequenze == true and self.playStartSequenze == true then
				-- debug:
				--renderText(0.1,0.1,0.021, tostring(self.curDuration).." <-curDuration");
				--renderText(0.1,0.12,0.021, tostring(self.startDuration).." <-startDuration");
				--renderText(0.1,0.14,0.021, tostring(self.curDurBackup).." <-curDurBackup");
				--renderText(0.1,0.16,0.021, tostring(self.whiteOutDuration).." <-whiteOutDuration");
				if checkDuration == nil then
					self.curDurBackup = self.time;
					checkDuration = true;
				end;
				self.curDuration = self.time - self.curDurBackup;
				if self.curDuration < self.startDuration  then
					self.reps.realAlpha = math.min(self.reps.maxAlpha, self.reps.realAlpha + 0.01);
					if self.diff < self.maxDiff and self.curDuration < self.whiteOutDuration then
						self.diff = math.min(self.diff + 0.01, self.maxDiff);
					else
						if self.curDuration > self.whiteOutDuration then
							self.diff = math.max(self.diff - 0.01, self.minDiff);
						else
							self.diff = self.maxDiff;
						end;		
					end;
				else
					self.reps.realAlpha = self.reps.maxAlpha;
					self.diff = math.max(self.diff - 0.01, self.minDiff);
					if self.diff == self.minDiff then
						self.playStartSequenze = false;
						self.diff = self.minDiff;
						self.curDuration = 0;
						checkDuration = nil;
						self.curDurBackup = nil;
					end;
				end;
				setShaderParameter(self.exhaustParticleSystems[1].shape, self.reps.parameter, self.diff*0.7, self.diff*0.7, self.diff*0.7, self.reps.realAlpha, false);	
				if self.klappe ~= nil then 
					setRotation(self.klappe, Utils.degToRad(-((self.motor.lastMotorRpm / 100) + 80)), 0, 0)
				end;
			else
			if self.klappe ~= nil then 
				setRotation(self.klappe, Utils.degToRad(-((self.motor.lastMotorRpm / 100) + 80)), 0, 0)
			end;
			-- berprfen ob der Traktor am beschleunigen ist
			if self.reps.accBackup < self.motor.lastMotorRpm then
				self.reps.isAcc = true;
			elseif self.reps.accBackup > self.motor.lastMotorRpm then
				self.reps.isAcc = false;
			end;
			local acc = 0;
			acc = -InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
			if InputBinding.isAxisZero(acc) then
				acc = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
			end;
		
			-- acc auf diese Art bedeutet, Tastatur -> w ist gedrckt -> 1, nix ist gedrckt -0, s gedrckt -> -1
			-- bei Pedal die genaue Stellung des Pedals von 0 - 1 und -1 

			-- Tempomatstufen 
			if self.motor.speedLevel == 1 then -- Tempomatstufe 1
				if self.motor.lastMotorRpm < (self.motor.maxRpm[1] - 100) then
					self.reps.realAlpha = math.min(self.reps.maxAlpha, self.reps.realAlpha + 0.01);
				else
					self.reps.realAlpha = math.max(self.reps.minAlpha, self.reps.realAlpha - 0.01);	
				end;
			end;
			if self.motor.speedLevel == 2 then -- Tempomatstufe 2
				if self.motor.lastMotorRpm < (self.motor.maxRpm[2] - 150) then
					self.reps.realAlpha = math.min(self.reps.maxAlpha, self.reps.realAlpha + 0.01);
				else
					self.reps.realAlpha = math.max(self.reps.minAlpha, self.reps.realAlpha - 0.01);	
				end;
			end;
			if self.motor.speedLevel == 3 then -- Tempomatstufe 3
				if self.motor.lastMotorRpm < (self.motor.maxRpm[3] - 250) then
					self.reps.realAlpha = math.min(self.reps.maxAlpha, self.reps.realAlpha + 0.01);
				else
					self.reps.realAlpha = math.max(self.reps.minAlpha, self.reps.realAlpha - 0.01);	
				end;
			end;
			if self.motor.speedLevel == 4 then -- Tempomatstufe 4
				if self.motor.lastMotorRpm < (self.motor.maxRpm[4] - 150) then
					self.reps.realAlpha = math.min(self.reps.maxAlpha, self.reps.realAlpha + 0.01);
				else
					self.reps.realAlpha = math.max(self.reps.minAlpha, self.reps.realAlpha - 0.01);	
				end;
			end;
		
			-- wenn keine Tempomatstufe aktiviert ist
			if self.motor.speedLevel == 0 then -- keine Tempomatstufe aktiviert, zunchst nur Qualm bei beschleunigung
				if self.reps.isAcc == true then
					self.reps.realAlpha = math.min(self.reps.maxAlpha, self.reps.realAlpha + 0.01);
				end;
				if self.reps.isAcc == false then
					self.reps.realAlpha = math.max(self.reps.minAlpha, self.reps.realAlpha - 0.1);
				end;
				if acc == 1 then -- wenn acc -> 1 ist dann ist Taste w gedrckt --> Vollgas
					if self.motor.lastMotorRpm < (self.motor.maxRpm[3] - 250) then -- raucht also auch wenn man am Berg an Speed verliert
						self.reps.realAlpha = math.min(self.reps.maxAlpha, self.reps.realAlpha + 0.01);
					end;
				end;
			end;
		
			setShaderParameter(self.exhaustParticleSystems[1].shape, self.reps.parameter, 0, 0, 0, self.reps.realAlpha, false);		
			self.reps.accBackup = self.motor.lastMotorRpm;	
			end;
		else
			if self.klappe ~= nil then
				setRotation(self.klappe, 0, 0, 0);
			end;
		end;
	end;
	if self.isMotorStarted == false then
		setRotation(self.klappe, 0, 0, 0);	
	end;
end;

function realExhaustParticleSystem:draw()
end;