frontloaderControllEvent = {};
frontloaderControllEvent_mt = Class(frontloaderControllEvent, Event);

InitEventClass(frontloaderControllEvent, "frontloaderControllEvent");

function frontloaderControllEvent:emptyNew()
    local self = Event:new(frontloaderControllEvent_mt);
    self.className="frontloaderControllEvent";
    return self;
end;

function frontloaderControllEvent:new(vehicle, anim, speed, doRestoreLimit)
    local self = frontloaderControllEvent:emptyNew()
    self.vehicle = vehicle;
	self.anim = anim;
	self.speed = speed;
    return self;
end;

function frontloaderControllEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.anim = streamReadInt8(streamId);
	self.speed = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function frontloaderControllEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.anim);
	streamWriteInt8(streamId, self.speed);
end;

function frontloaderControllEvent:run(connection)
	self.vehicle:setArmSpeed(self.anim, self.speed, true);
	if not connection:getIsServer() then
		--g_server:broadcastEvent(frontloaderControllEvent:new(self.vehicle, self.anim, self.speed, self.doRestoreLimit), nil, connection, self.object);
	end;
end;

function frontloaderControllEvent.sendEvent(vehicle, anim, speed,  noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			-- no need to broadcast the event: only the server need the information
			--g_server:broadcastEvent(frontloaderControllEvent:new(vehicle, anim, speed, doRestoreLimit), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(frontloaderControllEvent:new(vehicle, anim, speed));
		end;
	end;
end;