OdpalanieMPEvent = {};
OdpalanieMPEvent_mt = Class(OdpalanieMPEvent, Event);

InitEventClass(OdpalanieMPEvent, "OdpalanieMPEvent");

function OdpalanieMPEvent:emptyNew()
    local self = Event:new(OdpalanieMPEvent_mt);
    self.className="OdpalanieMPEvent";
    return self;
end;

function OdpalanieMPEvent:new(object, isRunning)
    local self = OdpalanieMPEvent:emptyNew()
    self.object = object;
	self.isRunning = isRunning;
    return self;
end;

function OdpalanieMPEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isRunning = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function OdpalanieMPEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isRunning);
end;

function OdpalanieMPEvent:run(connection)
	self.object:invokeIgnition(self.isRunning);
    if not connection:getIsServer() then
        g_server:broadcastEvent(OdpalanieMPEvent:new(self.object, self.isRunning), nil, connection, self.object);
    end;	
end;

function OdpalanieMPEvent.sendEvent(vehicle, isRunning)
	if g_server ~= nil then
		g_server:broadcastEvent(OdpalanieMPEvent:new(vehicle, isRunning), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(OdpalanieMPEvent:new(vehicle, isRunning));
	end;
end;
