-- Passenger on enter event-class
PassengerEnterEvent = {};
PassengerEnterEvent_mt = Class(PassengerEnterEvent, Event);

InitEventClass(PassengerEnterEvent, "PassengerEnterEvent");

function PassengerEnterEvent:emptyNew()
    local self = Event:new(PassengerEnterEvent_mt);
    self.className="PassengerEnterEvent";
    return self;
end;

function PassengerEnterEvent:new(vehicle, passenger, playerRootNode, playerCamera)
    local self = PassengerEnterEvent:emptyNew()
    self.vehicle = vehicle;
	self.passenger = passenger;
	self.playerRootNode = playerRootNode;
	self.playerCamera = playerCamera;
    return self;
end;

function PassengerEnterEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	local rootNodeId = streamReadInt32(streamId);
	self.passenger = streamReadString(streamId);
	self.playerCamera = streamReadInt32(streamId);

	print(rootNodeId);

    self.vehicle = networkGetObject(id);
	self.playerRootNode = networkGetObject(rootNodeId);
    self:run(connection);
end;

function PassengerEnterEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt32(streamId, networkGetObjectId(self.playerRootNode));
	streamWriteString(streamId, self.passenger);
	streamWriteInt32(streamId, self.playerCamera);
end;

function PassengerEnterEvent:run(connection)
	self.vehicle:onPassengerEnter(self.passenger, self.playerRootNode, self.playerCamera, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(PassengerEnterEvent:new(self.vehicle, self.passenger, self.playerRootNode, self.playerCamera), nil, connection, self.vehicle);
    end;
end;

function PassengerEnterEvent.sendEvent(vehicle, passenger, playerRootNode, playerCamera, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(PassengerEnterEvent:new(vehicle, passenger, playerRootNode, playerCamera), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(PassengerEnterEvent:new(vehicle, passenger, playerRootNode, playerCamera));
		end;
	end;
end;
