--
-- FendtGTA380
-- Specialization for FendtGTA380
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		11/11/10
-- @history:	v1.0 - Initial version
--				v2.0 - converted to 2011 and some bugfixes
--



Rainwipper = {};

function Rainwipper.prerequisitesPresent(specializations)
    return true;
end;

function Rainwipper:load(xmlFile)

	
	
    local wiperAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiper#rootNode"));
    self.wiperAnimCharSet = 0;
    if wiperAnimRootNode ~= nil and wiperAnimRootNode ~= 0 then
        self.wiperAnimCharSet = getAnimCharacterSet(wiperAnimRootNode);
        if self.wiperAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperAnimCharSet, getXMLString(xmlFile, "vehicle.wiper#clip"));
            assignAnimTrackClip(self.wiperAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperAnimCharSet, 0, true);
            local wiperAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiper#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperAnimCharSet, 0, wiperAnimSpeedScale);
            self.wiperAnimDuration = getAnimClipDuration(self.wiperAnimCharSet, clip);
        end;
    end;
	self.isWiperActive = false;
	self.finishWiper = true;
	
	self.moveDownIntervall = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.moveDownIntervall#ms"), 1000);
	self.updateJoint = false;
	self.doLowering = false;
	self.loweringDone = false;
	self.nextAction = false;
	self.delay = 0;
	self.implementCount = 0;
end;

function Rainwipper:delete()
end;

function Rainwipper:readStream(streamId, connection)
end;

function Rainwipper:writeStream(streamId, connection)
end;

function Rainwipper:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Rainwipper:keyEvent(unicode, sym, modifier, isDown)
end;

function Rainwipper:update(dt)
	
end;

function Rainwipper:updateTick(dt)

	if self:getIsActive() then	
		

		if not self.finishWiper then
			if getAnimTrackTime(self.wiperAnimCharSet, 0) % self.wiperAnimDuration <= 100 then
				setAnimTrackTime(self.wiperAnimCharSet, 0, 0.0);
				disableAnimTrack(self.wiperAnimCharSet, 0);			
				self.finishWiper = true;
			end;			
		end;
		
		
		
		if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
			if not self.isWiperActive then
				enableAnimTrack(self.wiperAnimCharSet, 0);
				self.isWiperActive = true;
			end;
		else
			if self.isWiperActive then
				self.isWiperActive = false;
				self.finishWiper = false;
			end;
		end;
		
		for _, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;
	end;
end;

function Rainwipper:draw()	
	
end;

function Rainwipper:attachImplement(implement)
	
	
	
end;

function Rainwipper:detachImplement(implementIndex)

	
end;

function Rainwipper:validateAttacherJoint(implement, jointDesc, dt)
   
end;

function Rainwipper:setFenderVisibility(isVisible)
	
end;

function Rainwipper:onLeave()
	if self.isWiperActive then
		disableAnimTrack(self.wiperAnimCharSet, 0);	
	end;
end;

function Rainwipper:onEnter()
	if self.isWiperActive then
		enableAnimTrack(self.wiperAnimCharSet, 0);	
	end;
end;