SetDuelWheelsEvent = {};
SetDuelWheelsEvent_mt = Class(SetDuelWheelsEvent, Event);

InitEventClass(SetDuelWheelsEvent, "SetDuelWheelsEvent");

function SetDuelWheelsEvent:emptyNew()
      local self = Event:new(SetDuelWheelsEvent_mt);
      self.className="SetDuelWheelsEvent";
      return self;
end;

function SetDuelWheelsEvent:new(object, active)
      local self = SetDuelWheelsEvent:emptyNew()
      self.active = active;
      self.object = object;
      return self;
end;

function SetDuelWheelsEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.active = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
 end;

function SetDuelWheelsEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.active);
end;

function SetDuelWheelsEvent:run(connection)
      self.object:setDuelWheelsVisibility(self.active, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetDuelWheelsEvent:new(self.object, self.active), nil, connection, self.object);
      end;
end;