-- Gaslimiter
-- Specialization fr Modorgas
--
-- @author  LS09 ?
-- @version v2.0
-- @date  15/02/11
-- v2.0 - converted to LS11 MR.X

gasLimiter = {};

function gasLimiter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function gasLimiter:load(xmlFile)

end;

function gasLimiter:delete()
end;

function gasLimiter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function gasLimiter:keyEvent(unicode, sym, modifier, isDown)
end;

function gasLimiter:update(dt)
    if self:getIsActiveForInput() then
        if InputBinding.isPressed(InputBinding.mehrRPM) then
		    self.motor.minRpm = self.motor.minRpm - 100;
		elseif InputBinding.isPressed(InputBinding.wenigerRPM) then
		    self.motor.minRpm = self.motor.minRpm + 100;
	    end;
    end;

    if self.isEntered then
		if self.motor.minRpm < -2200 then
			self.motor.minRpm = -2200;
		elseif self.motor.minRpm > 200 then
			self.motor.minRpm = 200;
		end;
	end;
end;

function gasLimiter:stopMotor()
    self.motor.minRpm = 200;
end;

function gasLimiter:onLeave()
    self.motor.minRpm = 200;
end;

function gasLimiter:draw()
   if self.isMotorStarted then
	    g_currentMission:addExtraPrintText(string.format(g_i18n:getText("GasLimiter_controls"), self.typeDesc) .. " " .. InputBinding.          getKeyNamesOfDigitalAction(InputBinding.mehrRPM) .. "/" .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.wenigerRPM));	
   end;
end;