--
-- Addon for moveable Farmerarm
--
-- @author Aranea
-- @date 01/02/2013
--

FarmerArm = {};

function FarmerArm.prerequisitesPresent(specializations)
	return true;
end;

function FarmerArm:load(xmlFile)
	self.armNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.characterNode#armIndex"));
	self.arm2Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.characterNode#arm2Index"));
end;

function FarmerArm:postLoad(xmlFile)
	if self.armNode ~= nil then
		setVisibility(self.armNode, false);
	end;
	if self.arm2Node ~= nil then
		setVisibility(self.arm2Node, false);
	end;
end;

function FarmerArm:delete()
end;

function FarmerArm:readStream(streamId, connection)
end;

function FarmerArm:writeStream(streamId, connection)
end;

function FarmerArm:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
end;

function FarmerArm:getSaveAttributesAndNodes(nodeIdent)
end;

function FarmerArm:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FarmerArm:keyEvent(unicode, sym, modifier, isDown)
end;

function FarmerArm:update(dt)
end;

function FarmerArm:updateTick(dt)
end;

function FarmerArm:draw()
end;

function FarmerArm:onEnter()
	if self.armNode ~= nil then
		setVisibility(self.armNode, true);
	end;
	if self.arm2Node ~= nil then
		setVisibility(self.arm2Node, true);
	end;
end;

function FarmerArm:onLeave()
	if self.armNode ~= nil then
		if self.disableCharacterOnLeave then
			setVisibility(self.armNode, false);
		else
			setVisibility(self.armNode, true);
		end;
	end;
if self.arm2Node ~= nil then
		if self.disableCharacterOnLeave then
			setVisibility(self.arm2Node, false);
		else
			setVisibility(self.arm2Node, true);
		end;
	end;
end;
