--
-- ForageWagonFix
--
-- Fix to make the forageWagon work as self propelled
--
-- @author  Stefan Geiger
-- @date  02/05/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

ForageWagonFix = {};

function ForageWagonFix.prerequisitesPresent(specializations)
    return true;
end

function ForageWagonFix:load(xmlFile)
    self.checkSpeedLimit = false;
	self:onReleaseBrake();
	self.updateWheels = false;
	
	self.rotationNodes = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.rotationNodes.rotationNode(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local rotSpeed = math.rad(Utils.getNoNil(getXMLFloat(xmlFile, key.."#rotSpeed"), 1)*0.001);
        if node ~= nil then
            table.insert(self.rotationNodes, {node=node, rotSpeed=rotSpeed, rotation=0});
        end;
        i = i + 1;
    end;
end

function ForageWagonFix:delete()
end

function ForageWagonFix:mouseEvent(posX, posY, isDown, isUp, button)
end

function ForageWagonFix:keyEvent(unicode, sym, modifier, isDown)
end

function ForageWagonFix:update(dt)
    -- Disable checkSpeedLimit so that attacheVehicle is not used by the foragewagon script
    -- Call this in the update loop in case it changed in another script
    self.checkSpeedLimit = false;
	
	if self:getIsActive() then
        if self.isTurnedOn then
			for _, node in pairs(self.rotationNodes) do
				node.rotation = (node.rotation + dt*node.rotSpeed) % (2*math.pi);
				setRotation(node.node, node.rotation, 0, 0);
			end;
		end;
    end;
end

function ForageWagonFix:updateTick(dt)
end

function ForageWagonFix:draw()
end
